#include <mbed.h>
#include <rtos.h>

extern "C" {
#include "pico_config.h"

    pico_time local_time;
    uint32_t last_os_time;

    void *pico_mutex_init(void)
    {
        return new Mutex();
    }

    void pico_mutex_lock(void *_m)
    {
        Mutex *m = (Mutex *)_m;
        m->lock();
    }

    void pico_mutex_unlock(void *_m)
    {
        Mutex *m = (Mutex *)_m;
        m->unlock();
    }

    void pico_mutex_deinit(void *_m)
    {
        Mutex *m = (Mutex *)_m;
        delete m;
    }
    
#ifdef PICO_MEASURE_STACK
int freeStack = STACK_TOTAL_WORDS;
void stack_fill_pattern(void * ptr)
{
    int * movingPtr = (int *)ptr;
    int * finalPtr = movingPtr - STACK_TOTAL_WORDS;
    while(movingPtr >= finalPtr)
    {
        *movingPtr = STACK_PATTERN;
        movingPtr--;
    }
}

void stack_count_free_words(void *ptr)
{
    int * movingPtr = (int *)ptr;
    int * finalPtr = movingPtr - STACK_TOTAL_WORDS;
    int tmpFreeStack = 0;
    
    while(finalPtr != movingPtr)
    {
        if(*finalPtr != STACK_PATTERN)
            break;
        tmpFreeStack++;
        finalPtr++;
    }
    freeStack = tmpFreeStack;
}

int stack_get_free_words(void)
{
    return freeStack;
}

#endif

}
