/*
 *  Copyright (c) 2012 Neal Horman - http://www.wanlink.com
 *
 *  License: MIT open source (http://opensource.org/licenses/MIT)
 *      Summary;
 *      Use / modify / distribute / publish it how you want and
 *      if you use it, or don't, you can't hold me liable for how
 *      it does or doesn't work.
 *      If it doesn't work how you want, don't use it, or change
 *      it so that it does work.
 */

#include "mbed.h"
#include "SeeedGrayOLED.h"

DigitalOut myled(LED1);

SeeedGrayOLED SeeedGrayOled(P0_10, P0_11);

int main()
{

    while(1) {
        SeeedGrayOled.init();             //initialize SEEED OLED display
        SeeedGrayOled.clearDisplay();     //Clear Display.
        SeeedGrayOled.setNormalDisplay(); //Set Normal Display Mode
        SeeedGrayOled.setVerticalMode();  // Set to vertical mode for displaying text

        for(char i=1; i < 11 ; i++) {
            SeeedGrayOled.setTextXY(i,0);  //set Cursor to first line, 0th column
            SeeedGrayOled.setGrayLevel(i); //Set Grayscale level. Any number between 0 - 15.
            SeeedGrayOled.putString("Hello World"); //Print Hello World
            wait_ms(1.0);
        }

        wait(5.0);
    }

}