/*
 * Author: Dan Cohen
 * Date: 15/02/14
 * Notes: Displays the IP address then any data that is sent from a connecting client
 * Client command line on my system:  
 * ./client 192.168.2.3 2000
 * 
*/


#include "mbed.h"
#include "EthernetInterface.h"
#include "eth_status.h"
#include "SeeedGrayOLED.h"
#include "USBSerial.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

SeeedGrayOLED SeeedGrayOled(P0_10, P0_11);

USBSerial serial;

//ETHERNET
#define ECHO_SERVER_PORT   2000

EthernetInterface    eth;
TCPSocketServer      server;
TCPSocketConnection  connection;

char readBuffer[1024];

// This is required because the Seeed Arch Pro doesn't have a 
// unique MAC address (if you don't have this function then the Ethernet Interface init()
// function will hang when it tries to find it.
extern "C" void mbed_mac_address(char *mac)
{

    mac[0] = 0x00;
    mac[1] = 0x02;
    mac[2] = 0xF7;
    mac[3] = 0xF1;
    mac[4] = 0x91;
    mac[5] = 0x9F;
};

int Init()
{
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;

    // Initialize the OLED display
    SeeedGrayOled.init();             // initialize SEEED OLED display
    SeeedGrayOled.clearDisplay();     // Clear Display.
    SeeedGrayOled.setNormalDisplay(); // Set Normal Display Mode
    SeeedGrayOled.setVerticalMode();  // Set to vertical mode for displaying text

    SeeedGrayOled.setTextXY(1,0);     //set Cursor to first line, 0th column

    SeeedGrayOled.setGrayLevel(15);   //Set Grayscale level. Any number between 0 - 15.

    eth.init();
    serial.printf("initiated\n");

    eth.connect();
    serial.printf("connected\n");
    serial.printf("My IP address: %s\n\n", eth.getIPAddress());
    SeeedGrayOled.clearDisplay();     // Clear Display.
    SeeedGrayOled.setTextXY(1,0); 
    SeeedGrayOled.putString("My IP:");
    SeeedGrayOled.setTextXY(3,0); 
    SeeedGrayOled.putString(eth.getIPAddress());

    server.bind(ECHO_SERVER_PORT);
    serial.printf("bound to port %d\n", ECHO_SERVER_PORT);
    server.listen(1);
    serial.printf("%s  - Speed: %d Mbps\n", get_transmission_status(), get_connection_speed());

    return 0;
}

int main()
{

    Init();

    while(true) {
        serial.printf("\nWait for new connection...\n");
        server.accept(connection);

        led3 = 0;

        serial.printf("Connection from: %s\n", connection.get_address());
        SeeedGrayOled.setTextXY(5,0); 
        SeeedGrayOled.putString("Connect IP: ");
        SeeedGrayOled.setTextXY(7,0);         
        SeeedGrayOled.putString(connection.get_address());

        char buffer[300];
        int ret;

        ret = connection.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)  {
            serial.printf("didn't get any message from the server connection\n");
        } else {
            buffer[ret] = '\0';
            serial.printf("Received %d chars from server:\n%s\n", ret, buffer);
        }

        char retBuffer[300];
        sprintf(retBuffer, "%d", buffer);

        serial.printf("Sending %d chars back to client :\n%s\n", ret, buffer);
        ret = connection.send_all   (buffer, sizeof(buffer)-1);
        SeeedGrayOled.setTextXY(9,0);        
        SeeedGrayOled.putString("D:          ");   
        SeeedGrayOled.setTextXY(9,4);        
        SeeedGrayOled.putString(buffer);
        
        connection.close();

        led3 = 1;

    }

}
