#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void Bewegen()
{
    bertl.Move();
}

void DrehLinks()
{
    bertl.TurnLeft();
}

void VierUnterenLeds()
{
    bertl.NibbleLeds(0x0F);
}

void LedAnmachen(int16_t led)
{
    bertl.TurnLedOn(led);
}

void LedAusmachen(int16_t led)
{
    bertl.TurnLedOff(led);
}

void RotGrunBlauLED()
{
    bertl.RGBLed(1,1,1);
}

void BlaueLedsAN()
{
    bertl.BlueLedsON();   
}

void BlaueLedsAUS()
{
    bertl.BlueLedsOFF();
}

void WarteBisKnopfGedrucktIst()
{
    bertl.WaitUntilButtonPressed();
}

void VorderseiteIstFrei()
{
    bertl.FrontIsClear();
}

void NebenPiepser()
{
    bertl.NextToABeeper();
}

void IstKnopfGedruckt(const int a)
{
    bertl.IsButtonPressed(a);
}

void KnopfGedrucktZuruckholen()
{
    bertl.ReturnButtonPressed(); 
}

int main() 
{
    while(1) 
    {
        
    }
}
