/*******************************************************************************
 * Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
 
#ifndef _MAX77816_H_
#define _MAX77816_H_
 
#include "mbed.h"
 
class MAX77816
{
 
public:
 
    /**
     * @brief   Register Addresses
     * @details Enumerated MAX77816 register addresses
     */
    typedef enum {
        REG_0,
        REG_1,
        REG_2,
        REG_3,
        REG_4,
        REG_5,
        REG_6,
        REG_7
    } registers_t;
 
 
    /**
     * MAX77816 constructor.
     *
     * @param sda mbed pin to use for SDA line of I2C interface.
     * @param scl mbed pin to use for SCL line of I2C interface.
     */
    MAX77816(PinName sda, PinName scl);
 
    /**
     * MAX77816 constructor.
     *
     * @param i2c I2C object to use.
     */
    MAX77816(I2C *i2c);
 
    /**
     * MAX77816 destructor.
     */
    ~MAX77816();
 
    /**
     * @brief   Initialize MAX77816
     */
    int32_t init();
 
    /**
     * @brief   Write Register
     * @details Writes data to MAX77816 register
     *
     * @param   reg_addr Register to write
     * @param   reg_data Data to write
     * @returns 0 if no errors, -1 if error.
     */
    int32_t writeReg(MAX77816::registers_t reg_addr, char reg_data);
 
    /**
     * @brief   Read Register
     * @details Reads data from MAX77816 register
     *
     * @param   reg_addr Register to read
     * @returns data if no errors, -1 if error.
     */
    int32_t readReg(MAX77816::registers_t reg_addr);
  
  
    int32_t writeBlock(MAX77816::registers_t startReg, MAX77816::registers_t stopReg, const uint8_t *data);
    int32_t readBlock(MAX77816::registers_t startReg, MAX77816::registers_t stopReg, uint8_t *data);
    
    int32_t getVersion();
    int32_t getChipRevision();
    int32_t getStatus();
    int32_t setVout(uint8_t reg_data);
    int32_t setVoutH(uint8_t reg_data);
    int32_t setIntMask(uint8_t reg_data);
    int32_t setIntMask();
    int32_t getInt();
    
private:
 
    I2C *i2c_;
    bool i2c_owner;
 
};
 
#endif /* _MAX77816_H_ */
 