 
#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include <string> 
#include <sstream>
#include <iostream>
#include <stdarg.h>
#include "serial_gui_if.h"
        
struct FUNCTION_TABLE{
    char func_name[128];
    int size_fname;
    int id;
    int argc;
    int arg_min[8];
    int arg_max[8]; 
}func_table[128];

//<mbed>command arg1 arg2 arg3 .... <end>

SERIAL_GUI_INTERFACE::SERIAL_GUI_INTERFACE(Serial *_serial) :
    serial(_serial)
{
    memset(argv, NULL, sizeof(argv));
}


SERIAL_GUI_INTERFACE::~SERIAL_GUI_INTERFACE()
{
        delete serial;    
}


int SERIAL_GUI_INTERFACE::set_function_info(char *_fname, 
                              int _arg, ...)
//int SERIAL_GUI_INTERFACE::set_function_info(
//                        char * _fname, 
//                        int _size_fname, 
//                        int _id, 
//                        int _argc
//                    )
{
    int icnt, iarg;
    va_list ap;

    va_start(ap, _arg);    
    for(icnt = 0; icnt < 128; icnt++) {
        if(func_table[icnt].id == 0 ) {
            strcpy(func_table[icnt].func_name, _fname);
            func_table[icnt].size_fname = _arg;
            func_table[icnt].id = va_arg(ap, int);
            func_table[icnt].argc = va_arg(ap, int);
            for(iarg= 0; iarg < func_table[icnt].argc; iarg++) {
                func_table[icnt].arg_min[iarg] = va_arg(ap, int);
                func_table[icnt].arg_max[iarg] = va_arg(ap, int);
            }
            va_end(ap); 
            return func_table[icnt].id;
        }
    }
    va_end(ap); 
    return -1;
} 

int SERIAL_GUI_INTERFACE::get_serial_cmd_wo_head()
{    
    int ipos = 0;
    char tail = '\n';
    char recvStr[128];
    char seps[] = "\n\t;(,) ";
        
    memset(recvStr, NULL, sizeof(recvStr));
    memset(argv, NULL, sizeof(argv));
    
    //Waiting function
    while((recvStr[ipos] = serial->getc()) != tail){        
        //serial->printf("check_serial_cmd\n");
        
        if(++ipos >= sizeof(recvStr)){            
            serial->printf("Recv Buffer Size Error\n");
            return -1;
        }
    }

    ipos = 0;
    argv[ipos] = strtok( &recvStr[0], seps );
    while( argv[ipos] != NULL ) {   
        //serial->printf("arg[%d] = %s \n",ipos, argv[ipos]);
        argv[++ipos] = strtok( NULL, seps );
    }     
    
    for(ipos = 0; ipos < 128; ipos++) {
        if(strncmp(argv[0], func_table[ipos].func_name,             
                                 func_table[ipos].size_fname) == 0) {
            //serial->printf("found %s arg[%d] @ %d sizefname %d\n",argv[0], ipos, func_table[ipos].id, func_table[ipos].size_fname);
            return func_table[ipos].id;     
        }
    }
    
    return -1;   
}

int SERIAL_GUI_INTERFACE::get_serial_cmd()
{    
    int rval = 0;
    char recvStr[6], ihead = 0;
    char *head = "<mbed>";
    char tail = '\n';
    
    memset(recvStr, NULL, sizeof(recvStr));
    //Waiting Headers
    while(1){
        
        //serial->printf("check_serial\n");
        
        if((recvStr[ihead] = serial->getc())== tail)
        {
            ihead = 0;
            continue;
        }
                
        if(++ihead == sizeof(recvStr)){            
            if(strncmp(head,recvStr,sizeof(recvStr)) == 0){
                //serial->printf("!! find Head %s \n", recvStr);                
                
                rval = get_serial_cmd_wo_head();
                break;
            }
            ihead = 0;    
        }                
    }
    serial->printf("id %d \n", rval);
    return rval;   
}


void SERIAL_GUI_INTERFACE::req_function_info(void)
{
    int icnt, iarg;
    
    serial->printf("func name_size id argc arg(min, max)\n");
    for(icnt = 0; icnt < 128; icnt++) {        
        if(func_table[icnt].id <1) 
            return;
        
        serial->printf("%s %d  0x%x %d ",
                        func_table[icnt].func_name,  
                        func_table[icnt].size_fname,
                        func_table[icnt].id,
                        func_table[icnt].argc
                    );
                        
        for(iarg = 0; iarg < func_table[icnt].argc; iarg++) {  
            serial->printf(" 0x%x 0x%x", 
                            func_table[icnt].arg_min[iarg],
                            func_table[icnt].arg_max[iarg]
            );
        }
        serial->printf("\n");
    }   
    return;
} 


int SERIAL_GUI_INTERFACE::get_argi(int _n)
{
    unsigned int hex_value
        = std::strtoul(argv[_n], 0, 16);
    return 0;
}

char* SERIAL_GUI_INTERFACE::get_arg(int _n)
{
    return argv[_n];
}


void SERIAL_GUI_INTERFACE::send_reg_value(int _reg, int _data)
{
    serial->printf("0x%x = 0x%x", _reg, _data);
}