/**********************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "max77816.h"

int main()
{
    unsigned int icnt = 0;
    
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    I2C i2cBus(P5_7, P6_0);
    i2cBus.frequency(400000);
    MAX77816 max77816(&i2cBus);
    rLED = rLED;
    wait_ms(100);    
    
    max77816.writeReg(MAX77816::REG_3, 0x71);
    while(1) {
       uint8_t regValue[8];
       int retVal = max77816.readBlock(MAX77816::REG_0, MAX77816::REG_7, regValue);
       if(retVal < 0) {
          printf("Error reading Register value\n");
          rLED = !rLED;
          continue;
       }
       
       printf("MAX77816 ReadCnt %d : ", icnt++);
       for(int ireg = 0; ireg< 8; ireg++)
           printf("REG[0x%02X] = 0x%02X ", ireg, regValue[ireg]);           
       printf("\n");
       wait(1);
       
       max77816.setVout(icnt&0x7f);
       max77816.setVoutH(icnt&0x7f);
       
       printf("\033[H");  //home
       printf("\033[0J"); //erase from cursor to end of screen
       gLED = !gLED;
    }
}

