//libraries
#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"  
#include "MODSERIAL.h"
#include "QEI.h"

//Define objects
   //EMG
    AnalogIn    emg_biceps_right_in( A0);              //analog in to get EMG biceps  (r) in to c++
    AnalogIn    emg_triceps_right_in(A1);               //analog in to get EMG triceps (r) in to c++
    AnalogIn    emg_biceps_left_in  (A2);               //analog in to get EMG biceps  (l) in to c++

    //Encoder
    DigitalIn encoder1A(D13);
    DigitalIn encoder1B(D12);
    DigitalIn encoder2A(D11); 
    DigitalIn encoder2B(D10);
    
    //callibration buttons
    DigitalIn   button_calibration_biceps  (SW3);                //button to start calibration biceps
    DigitalIn   button_calibration_triceps (SW2);               // button to start calibration tricps
    DigitalIn   buttontest                  (D9);
    DigitalIn   buttontest2                 (PTC12);    
    //tickers
    Ticker      sample_timer;               //ticker
    Ticker      switch_function;            //ticker
    Ticker      ticker_calibration_biceps;
    Ticker      ticker_calibration_triceps;
    Ticker      encoder_ticker;


//everything for monitoring
    HIDScope    scope(5);                       //open 5 channels in hidscope
    MODSERIAL   pc(USBTX, USBRX);               //pc connection
    DigitalOut  red(LED_RED);
    DigitalOut  green(LED_GREEN);
    DigitalOut  blue(LED_BLUE);
 
//motors
    DigitalOut direction_motor1(D4);
    PwmOut pwm_motor1(D5);
    DigitalOut direction_motor2(D7);
    PwmOut pwm_motor2(D6);

//define variables

     //for motorcontrol
        const int cw = 0;                   // motor should turn clockwise
        const int ccw =1;                   // motor should turn counterclockwise
        const double gearboxratio=131.25;    // gearboxratio from encoder to motor
        const double rev_rond=64.0;          // revolutions per round of encoder
        int    onoffsignal_biceps=0;        // on/off signal: 1; biceps activation, 0: nothing, -1, triceps activation
        int    switch_signal_triceps=0;     // switching between motors. 
        
        volatile double cut_off_value_biceps_right =    0.04;       //tested, normal values. Can be changed by calibration
        volatile double cut_off_value_biceps_left  =    -0.04;      //volatiles becaused changen in interrupt
        volatile double cut_off_value_triceps=-0.03;       
        double signal_biceps_sum;
        double bicepstriceps_rightarm;
        int motorswitch=0;
        
        //encoders
         volatile double rev_counts_motor1=0;
         volatile double rev_counts_motor2=0;
         volatile double counts_encoder1;
         volatile double counts_encoder2;
         QEI Encoder1(D12,D13, NC, rev_rond,QEI::X4_ENCODING);  // maakt een encoder aan! D12/D13 ingangen, rev_rond zijn aantal pulsen per revolutie! Bovenaan in te stellen. 
         QEI Encoder2(D10,D11, NC, rev_rond,QEI::X4_ENCODING);
        
        //variables and constants for calibration
        const float percentage_max_triceps=0.3;
        const float percentage_max_biceps =0.3;
        double max_biceps;                          //calibration maximum biceps
        double max_triceps;                         //calibration maximum triceps
    
    //biceps  arm 1, right arm
    double emg_biceps_right;
    double emg_filtered_high_biceps_right;
    double emg_abs_biceps_right;
    double emg_filtered_biceps_right;
    double emg_filtered_high_notch_1_biceps_right;
    //double emg_filtered_high_notch_1_2_biceps_right;
    
    //triceps arm 1, right arm
    double emg_triceps_right;
    double emg_filtered_high_triceps_right;
    double emg_abs_triceps_right;
    double emg_filtered_triceps_right;
    double emg_filtered_high_notch_1_triceps_right;
    
    //biceps  arm 1, left arm
    double emg_biceps_left;
    double emg_filtered_high_biceps_left;
    double emg_abs_biceps_left;
    double emg_filtered_biceps_left;
    double emg_filtered_high_notch_1_biceps_left;
    
    //before abs filtering
    
    //b1 = biceps right arm
    BiQuad filterhigh_b1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
    BiQuad filternotch1_b1 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);
    
    //t1= triceps right arm
    BiQuad filterhigh_t1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
    BiQuad filternotch1_t1 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);
    
    //b2= biceps left arm
    BiQuad filterhigh_b2(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
    BiQuad filternotch1_b2 (9.9376e-01 , -1.8902e-00,   9.9376e-01 , -1.8902e-00 ,  9.875e-01);
    
    //after abs filtering
    BiQuad filterlow_b1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);
    BiQuad filterlow_t1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);
    BiQuad filterlow_b2 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);

//function teller
void encoder_working(){
       counts_encoder1 = Encoder1.getPulses(); 
       rev_counts_motor1=counts_encoder1/(gearboxratio*rev_rond);
       counts_encoder2 = Encoder2.getPulses(); 
       rev_counts_motor2=counts_encoder2/(gearboxratio*rev_rond);  }

void SwitchN() {                        // maakt simpele functie die 1 bij n optelt
    if(switch_signal_triceps==1)
    {
        motorswitch++;
        
    if (motorswitch%2==0)  
      {pc.printf("If you contract the right arm, the robot will go right \r\n");
     pc.printf("If you contract biceps of the left arm, the robot will go left \r\n");
    pc.printf("\r\n");
        green=0;
        red=1;
          }
    
    else
    {pc.printf("If you contract the biceps of right arm, the robot will go up \r\n");
     pc.printf("If you contract the biceps of left arm, the robot will go down \r\n");
     pc.printf("\r\n");
        green=1;
        red=0;
   
    }    

    }
    }
    
//functions which are called in ticker to sample the analog signal

//callibration
void calibration_biceps(){
        if (button_calibration_biceps==0){
        pc.printf("start of calibration biceps, contract maximal \n");
        red=1;
        green=1;
        blue=0;
        
        for(int n =0; n<1500;n++)                                                  //read for 2000 samples as calibration
                {
        emg_biceps_right=emg_biceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_biceps_right= filterhigh_b1.step(emg_biceps_right);
        emg_filtered_high_notch_1_biceps_right=filternotch1_b1.step(emg_filtered_high_biceps_right);
        emg_abs_biceps_right=fabs(emg_filtered_high_notch_1_biceps_right); //fabs because float
        emg_filtered_biceps_right=filterlow_b1.step(emg_abs_biceps_right);
                                
            if (emg_filtered_biceps_right > max_biceps)                    //determine what the highest reachable emg signal is
                {
            max_biceps = emg_filtered_biceps_right;
            
                }
                wait(0.001f); //to sample at same freq; 1000Hz
                }
            cut_off_value_biceps_right=percentage_max_biceps*max_biceps; 
            cut_off_value_biceps_left=-cut_off_value_biceps_right;
            //toggle lights
            blue=!blue;
            
            pc.printf(" end of calibration\r\n",cut_off_value_biceps_right );   
            pc.printf(" change of cv biceps: %f ",cut_off_value_biceps_right );
            
            wait(0.2f);
              
            if (motorswitch%2==0)
            {green=0;
            red=1;}
            
            else       {green=1;
            red=0;}
                }
                }
                
void calibration_triceps(){
        if(button_calibration_triceps==0){
        red=1;
        green=1;
        blue=0;
      
        pc.printf("start of calibration triceps\r\n");

        for(int n =0; n<1500;n++)                                                  //read for 2000 samples as calibration
                {
        emg_triceps_right=emg_triceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_triceps_right= filterhigh_t1.step(emg_triceps_right);
        emg_filtered_high_notch_1_triceps_right=filternotch1_t1.step(emg_filtered_high_triceps_right);
        emg_abs_triceps_right=fabs(emg_filtered_high_notch_1_triceps_right); //fabs because float
        emg_filtered_triceps_right=filterlow_t1.step(emg_abs_triceps_right);
                              
            if (emg_filtered_triceps_right > max_triceps)                    //determine what the highest reachable emg signal is
                {
            max_triceps = emg_filtered_triceps_right;
            
                }
                wait(0.001f); //to sample at same freq; 1000Hz
                }
            cut_off_value_triceps=-percentage_max_triceps*max_triceps; 
            pc.printf(" end of calibration\r\n");   
            pc.printf(" change of cv triceps: %f ",cut_off_value_triceps ); 
            blue=!blue;
            wait(0.2f);
            if (motorswitch%2==0)
            {green=0;
            red=1;}
            
            else       {green=1;
            red=0;}  
                }
                }

void filter(){
        //biceps right arm read+filtering
        emg_biceps_right=emg_biceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_biceps_right= filterhigh_b1.step(emg_biceps_right);
        emg_filtered_high_notch_1_biceps_right=filternotch1_b1.step(emg_filtered_high_biceps_right);
        emg_abs_biceps_right=fabs(emg_filtered_high_notch_1_biceps_right); //fabs because float
        emg_filtered_biceps_right=filterlow_b1.step(emg_abs_biceps_right);
        
        //triceps right arm read+filtering
        emg_triceps_right=emg_triceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_triceps_right= filterhigh_t1.step(emg_triceps_right);
        emg_filtered_high_notch_1_triceps_right=filternotch1_t1.step(emg_filtered_high_triceps_right);
        emg_abs_triceps_right=fabs(emg_filtered_high_notch_1_triceps_right); //fabs because float
        emg_filtered_triceps_right=filterlow_t1.step(emg_abs_triceps_right);
        
        //biceps left arm read+filtering
        emg_biceps_left=emg_biceps_left_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_biceps_left= filterhigh_b2.step(emg_biceps_left);
        emg_filtered_high_notch_1_biceps_left=filternotch1_b2.step(emg_filtered_high_biceps_left);
        emg_abs_biceps_left=fabs(emg_filtered_high_notch_1_biceps_left); //fabs because float
        emg_filtered_biceps_left=filterlow_b2.step(emg_abs_biceps_left);
          
        //signal substraction of filter biceps and triceps. right Biceps + left biceps -
        signal_biceps_sum=emg_filtered_biceps_right-emg_filtered_biceps_left;
        bicepstriceps_rightarm=emg_filtered_biceps_right-emg_filtered_triceps_right;       
        //creating of on/off signal with the created on/off signals, with if statement   for right arm!    
        if (signal_biceps_sum>cut_off_value_biceps_right)
        {onoffsignal_biceps=1;}
          
        else if (signal_biceps_sum<cut_off_value_biceps_left)
        {
        onoffsignal_biceps=-1;
        }    
        
        else
        {onoffsignal_biceps=0;}
                      
        //creating on/off signal for switch (left arm)
        
        if (bicepstriceps_rightarm<cut_off_value_triceps)
        {
        switch_signal_triceps=1;    
        }    
        
        else
        {
        switch_signal_triceps=0;              
        }
        
        //send signals  to scope
        scope.set(0, emg_filtered_biceps_right);            //set emg signal to scope in channel 0
        scope.set(1, emg_filtered_triceps_right);           // set emg signal to scope in channel 1
        scope.set(2, emg_filtered_biceps_left);                     // set emg signal to scope in channel 2
        scope.set(3, onoffsignal_biceps);
        
        scope.send();                       //send all the signals to the scope
                }

//program

int main()
{  
pc.baud(115200); //connect with pc with baudrate 115200

sample_timer.attach(&filter, 0.001);                    //continously execute the EMG reader and filter, it ensures that filter and sampling is executed every 1/frequency seconds
switch_function.attach(&SwitchN,1.0);                   //switch is every second available
ticker_calibration_biceps.attach (&calibration_biceps,2.0);   //to call calibration biceps, stop everything else
ticker_calibration_triceps.attach(&calibration_triceps,2.0);  //to call calibration triceps, stop everything else


  if (motorswitch%2==0) {
        pc.printf("If you contract the right arm, the robot will go right \r\n");
        pc.printf("If you contract biceps of the left arm, the robot will go left \r\n");
        pc.printf("\r\n");
        green=0;
        red=1;
        blue=1;
          }
    
    else
    {pc.printf("If you contract the biceps of right arm, the robot will go up \r\n");
     pc.printf("If you contract the biceps of left arm, the robot will go down \r\n");
     pc.printf("\r\n");
    green=1;
    red=0;
    blue=1;
           
    }    
//endless loop


    while (true) {                        // zorgt er voor dat de code oneindig doorgelopen wordt  
    
                  
    //motor control with muscles.
    if (buttontest==0)                           // als s ingedrukt wordt gebeurd het volgende
    {
         if (motorswitch%2==0 && rev_counts_motor1<3.4)                     // als s ingedrukt wordt en het getal is even gebeurd het onderstaande
         { 
           direction_motor1 = ccw; //right
           pwm_motor1 = 0.18; 
           pc.printf("ccw m1\r\n");
           encoder_working();
           
         } 
         
         else if (motorswitch%2!=0 && rev_counts_motor2<10.0)                        // als s is ingedrukt maar het getal is niet even (dus oneven) gebeurdt het onderstaande
         {
           direction_motor2 = ccw;  //down
           pwm_motor2 = 1;
           encoder_working();
          
         }      
              
    }
    else if (buttontest2==0)                     
    {
         if (motorswitch%2==0 && rev_counts_motor1>-3.4)    //restriction
         {
           direction_motor1 = cw; //left
           pwm_motor1 = 0.18;
           encoder_working();
                                    
        } 
         else if(motorswitch%2!=0 && rev_counts_motor2>-19.0)                          // als d is ingedrukt maar het getal is niet even (dus oneven) gebeurt het onderstaande
         {
           direction_motor2 = cw;
           pwm_motor2 = 1;
           encoder_working();
              
         }  
    }   
    else{
       
    pwm_motor2=0;
    pwm_motor1=0;
    encoder_working();
             
       }              
    pc.printf("rev_counts_motor1= %f \r\n",rev_counts_motor1);          
    pc.printf("rev_counts_motor2= %f \r\n",rev_counts_motor2);          

}
 }       