//libraries
#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"  
#include "MODSERIAL.h"

//Define objects
AnalogIn    emg_biceps_right_in( A0 );              //analog in to get EMG biceps  (r) in to c++
AnalogIn    emg_triceps_right_in(A1);               //analog in to get EMG triceps (r) in to c++
AnalogIn    emg_biceps_left_in  (A2);               //analog in to get EMG biceps  (l) in to c++
DigitalIn   button_calibration_biceps (SW3);                //button to start calibration biceps
DigitalIn   button_calibration_triceps (SW2);               // button to start calibration tricps

Ticker      sample_timer;               //ticker
Ticker      switch_function;            //ticker
Ticker      calibration_ticker          //ticker
HIDScope    scope(5);                   //open 3 channels in hidscope
MODSERIAL pc(USBTX, USBRX);             //pc connection

//motors
DigitalOut richting_motor1(D4);
PwmOut pwm_motor1(D5);
DigitalOut richting_motor2(D7);
PwmOut pwm_motor2(D6);

//digital out

DigitalOut  led(LED_GREEN);         //led included to check where code is

//define variables
//other
int    onoffsignal_rightarm=0;              // on/off signal: 1; biceps activation, 0: nothing, -1, triceps activation
int    switch_signal_leftarm=0;             // switching between motors. 
double cut_off_value_biceps =0.06;          //gespecificeerd door floortje
double cut_off_value_triceps=-0.03;         //gespecificeerd door floorte
double signal_right_arm;                    //signal right arm
double max_biceps;                          //calibration maximum biceps
double max_triceps;                         //calibration maximum triceps
int n = 0;                                  //start van de teller wordt op nul gesteld, om te kunnen switchen
 
//biceps  arm 1, right arm
double emg_biceps_right;
double emg_filtered_high_biceps_right;
double emg_abs_biceps_right;
double emg_filtered_biceps_right;
double emg_filtered_high_notch_1_biceps_right;
double emg_filtered_high_notch_1_2_biceps_right;

//triceps arm 1, right arm
double emg_triceps_right;
double emg_filtered_high_triceps_right;
double emg_abs_triceps_right;
double emg_filtered_triceps_right;
double emg_filtered_high_notch_1_triceps_right;
double emg_filtered_high_notch_1_2_triceps_right;

//biceps  arm 1, left arm
double emg_biceps_left;
double emg_filtered_high_biceps_left;
double emg_abs_biceps_left;
double emg_filtered_biceps_left;
double emg_filtered_high_notch_1_biceps_left;
double emg_filtered_high_notch_1_2_biceps_left;

//before abs filtering

//b1 = biceps right arm
BiQuad filterhigh_b1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
BiQuad filternotch1_b1 (9.9115e-01, -1.8853e+00, 9.9115e-01 ,-1.8909e+00  , 9.9103e-01);
BiQuad filternotch2_b1(1.0000e+00, -1.9022e+00, 1.0000e+00,  -1.8965e+00 , 9.9127e-01);

//t1= triceps right arm
BiQuad filterhigh_t1(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
BiQuad filternotch1_t1 (9.9115e-01, -1.8853e+00, 9.9115e-01 ,-1.8909e+00  , 9.9103e-01);
BiQuad filternotch2_t1(1.0000e+00, -1.9022e+00, 1.0000e+00,  -1.8965e+00 , 9.9127e-01);

//b2= biceps left arm
BiQuad filterhigh_b2(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
BiQuad filternotch1_b2 (9.9115e-01, -1.8853e+00, 9.9115e-01 ,-1.8909e+00  , 9.9103e-01);
BiQuad filternotch2_b2(1.0000e+00, -1.9022e+00, 1.0000e+00,  -1.8965e+00 , 9.9127e-01);

//after abs filtering
BiQuad filterlow_b1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);
BiQuad filterlow_t1 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);
BiQuad filterlow_b2 (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);

//function teller
void SwitchN() {                        // maakt simpele functie die 1 bij n optelt
    if(switch_signal_leftarm==1)
    {
        n++;
        wait(0.5f);
    }    
    }
    
//functions which are called in ticker to sample the analog signal

void filter(){
        //biceps right arm read+filtering
        emg_biceps_right=emg_biceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_biceps_right= filterhigh_b1.step(emg_biceps_right);
        emg_filtered_high_notch_1_biceps_right=filternotch1_b1.step(emg_filtered_high_biceps_right);
        emg_filtered_high_notch_1_2_biceps_right=filternotch2_b1.step(emg_filtered_high_notch_1_biceps_right);
        emg_abs_biceps_right=fabs(emg_filtered_high_notch_1_2_biceps_right); //fabs because float
        emg_filtered_biceps_right=filterlow_b1.step(emg_abs_biceps_right);
        
        //triceps right arm read+filtering
        emg_triceps_right=emg_triceps_right_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_triceps_right= filterhigh_t1.step(emg_triceps_right);
        emg_filtered_high_notch_1_triceps_right=filternotch1_t1.step(emg_filtered_high_triceps_right);
        emg_filtered_high_notch_1_2_triceps_right=filternotch2_t1.step(emg_filtered_high_notch_1_triceps_right);
        emg_abs_triceps_right=fabs(emg_filtered_high_notch_1_2_triceps_right); //fabs because float
        emg_filtered_triceps_right=filterlow_t1.step(emg_abs_triceps_right);
        
        //biceps left arm read+filtering
        emg_biceps_left=emg_biceps_left_in.read();                            //read the emg value from the elektrodes
        emg_filtered_high_biceps_left= filterhigh_b2.step(emg_biceps_left);
        emg_filtered_high_notch_1_biceps_left=filternotch1_b2.step(emg_filtered_high_biceps_left);
        emg_filtered_high_notch_1_2_biceps_left=filternotch2_b2.step(emg_filtered_high_notch_1_biceps_left);
        emg_abs_biceps_left=fabs(emg_filtered_high_notch_1_2_biceps_left); //fabs because float
        emg_filtered_biceps_left=filterlow_b2.step(emg_abs_biceps_left);
          
        //signal substraction of filter biceps and triceps. Biceps +,triceps -
        signal_right_arm=emg_filtered_biceps_right-emg_filtered_triceps_right;
               
        //creating of on/off signal with the created on/off signals, with if statement   for right arm!    
        if (signal_right_arm>cut_off_value_biceps)
        {onoffsignal_rightarm=1;}
          
        else if (signal_right_arm<cut_off_value_triceps)
        {
        onoffsignal_rightarm=-1;
        }    
        
        else
        {onoffsignal_rightarm=0;}
                      
        //creating on/off signal for switch (left arm)
        
        if (emg_filtered_biceps_left>cut_off_value_biceps)
        {
        switch_signal_leftarm=1;    
        }    
        
        else
        {
        switch_signal_leftarm=0;              
        }
        
        //send signals  to scope
        scope.set(0, emg_filtered_biceps_right);            //set emg signal to scope in channel 0 // change into raw signal! 
        scope.set(1, emg_filtered_triceps_right);           // set emg signal to scope in channel 1// change into raw signal!
        scope.set(2, emg_filtered_biceps_left);             // set emg signal to scope in channel 2
        scope.set(3, onoffsignal_rightarm);                 // set emg signal to scope in channel 3
        scope.set(4, switch_signal_leftarm);
        
        scope.send();                       //send all the signals to the scope
                }

//calibration function
void calibration(){
            if(button_calibration==0)
            {
            for(int n =0; n<2000;n++)                                                  //read for 5000 samples as calibration
                {
            emg_biceps_right=emg_biceps_right_in.read();                            //read the emg value from the elektrodes
            emg_filtered_high_biceps_right= filterhigh.step(emg_biceps_right);      //highpass
            emg_abs_biceps_right=fabs(emg_filtered_high_biceps_right);              //fabs because float
            emg_filtered_biceps_right=filterlow.step(emg_abs_biceps_right);         //lowpass to envelope
                        
            if (emg_filtered_biceps_right > max_right_biceps)                    //determine what the highest reachable emg signal is
                {
            max_right_biceps = emg_filtered_biceps_right;
                }
                }
            cut_off_value=0.2*max_right_biceps; 
            pc.printf(" change of cv %f ",cut_off_value );   
            }
                }

//program

int main()
{  
pc.baud(115200);
sample_timer.attach(&filter, 0.001);        //continously execute the EMG reader and filter, it ensures that filter and sampling is executed every 1/frequency seconds
switch_function.attach(&SwitchN,1);
//endless loop

    while (true) {                        // zorgt er voor dat de code oneindig doorgelopen wordt  
       
    if (onoffsignal_rightarm==1)                           // als s ingedrukt wordt gebeurd het volgende
    {
         if (n%2==0)                     // als s ingedrukt wordt en het getal is even gebeurd het onderstaande
         {
           pc.printf("n is even \n\r"); // print lijn "n is even"
           pc.printf("up \n\r");        // print lijn "up"   
           richting_motor1 = 2.5;
           pwm_motor1 = 1; 
                  
         } 
         
         else                           // als s is ingedrukt maar het getal is niet even (dus oneven) gebeurdt het onderstaande
         {
           pc.printf("n is odd \n\r");  // print lijn "n is odd"
           pc.printf("left \n\r");      // print lijn "left"
           richting_motor2 = 2.5;
           pwm_motor2 = 1;
           
         }      
              
    }
    else if (onoffsignal_rightarm==-1)                     // als d ingedrukt wordt gebeurd het volgende
    {
         if (n%2==0)                     // als d is ingedrukt en n is even dan gebeurd het volgende
         {
           pc.printf("n is even \n\r"); // print lijn "n is even"
           pc.printf("down \n\r");      // print lijn "down"   
           richting_motor1 = 0;
           pwm_motor1 = 1;
           
        } 
         else                           // als d is ingedrukt maar het getal is niet even (dus oneven) gebeurdt het onderstaande
         {
           pc.printf("n is odd \n\r"); // print lijn "n is odd"
           pc.printf("right \n\r");    // print lijn "right"
           richting_motor2 = 0;
           pwm_motor2 = 1;
                
         }  
    }   
    else{
       pc.printf("motor staat stil \n\r");
    pwm_motor2=0;
    pwm_motor1=0;
       }              
               
}
        
}