#include "mbed.h" //standaard bieb mbed
#include "QEI.h"  //bieb voor encoderfuncties in c++
#include "MODSERIAL.h" //bieb voor modserial
//alle ingangen definieren
DigitalIn encoder1A(D13); 
DigitalIn encoder1B(D12);
DigitalIn button_cw(D11);
DigitalIn button_ccw(D9);
DigitalOut ledcw(D10);
DigitalOut ledccw(D2);
DigitalOut motor1(D4);
PwmOut pwm_motor1(D5);
MODSERIAL pc(USBTX, USBRX);

//constanten
const int CW = 2.5; //definitie rechtsom 'lage waarde'
const int CCW =0; //definitie linksom 'hoge waarde'
const float gearboxratio=131; // gearboxratio van encoder naar motor
const int rev_rond=64;        // aantal revoluties per omgang van de encoder
//programma
int main ()
{
    pc.baud(115200); //contact maken met computer
    QEI Encoder(D12,D13, NC, rev_rond);  // maakt een encoder aan! D12/D13 ingangen, rev_rond zijn aantal pulsen per revolutie! Bovenaan in te stellen. 
    float counts_encoder;                  //variabele counts aanmaken
    float rev_counts_motor  ;                   //variabele motor rondjes aanmaken in radialen!!
             
    while(true)
    {
    if (button_cw==0)
        { //als knop is aan dan
        ledcw=1; //lamp aan
        motor1= CW; //motor clockwise
        pwm_motor1=2.5;     //Volt door de motor
        counts_encoder = Encoder.getPulses(); //tellen van de pulsen in  
        rev_counts_motor=counts_encoder/(gearboxratio*rev_rond);              //berekenen van het aantal rondjes van motor. Gedeeld door gearboxratio en rev rond, om naar motorrondjes te gaan in plaats van pulsen van encoder!
        pc.printf("motor rondjes: %f \r\n", rev_counts_motor);                  //weergeven
        }
    else if (button_ccw==0)
        { ledccw=1;
        motor1= CCW;
        pwm_motor1=2.5;
        counts_encoder = Encoder.getPulses(); //tellen van de pulsen in  
        rev_counts_motor=counts_encoder/(gearboxratio*rev_rond);            //weergeven van het aantal rondjes
        pc.printf("motor rondjes: %f \r\n", rev_counts_motor);   
        }    
    
    else { 
    ledcw=0; ledccw=0;
    pwm_motor1=0;
        }
    }
}