//libraries
#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h"  

//Define objects
AnalogIn    emg0( A0 );             //analog in to get EMG in to c++
Ticker      sample_timer;           //ticker
HIDScope    scope( 3);              //open 3 channels in hidscope
DigitalOut richting_motor1(D4);     //motor1 direction output    
PwmOut pwm_motor1(D5);              //motor1 velocity  output
DigitalOut  led(LED_GREEN);

//define variables
double emg_0_value;
double emg_gefilterd;
double emg_abs;
int    onoffsignal=0;
double cut_off_value=0.05; //gespecifeerd door floortje

biquadFilter filterhigh1(-1.1430, 0.4128, 0.6389, -1.2779, 0.6389);


void filter(){
        emg_0_value=emg0.read();                            //read the emg value from the elektrodes
        emg_gefilterd= filterhigh1.step(emg_0_value);
        emg_abs=abs(emg_gefilterd);
        led=!led;
        
        if (emg_abs>cut_off_value)
        {onoffsignal=1;}
          
        else 
        {onoffsignal=0;}
                      
        //send signals  to scope
        scope.set(0, emg_0_value );           //set emg signal to scope in channel 1
        scope.set(1, emg_gefilterd );    
        scope.set(2, onoffsignal);
        scope.send();                       //send all the signals to the scope
                }

//program

int main()
{  
sample_timer.attach(&filter, 0.001);        //continously execute the EMG reader and filter, it ensures that filter and sampling is executed every 1/frequency seconds

//endless loop

    while(1) 
    {    
        if (onoffsignal==1)
        {
        richting_motor1 = 0;    //motordirection (ccw)
        pwm_motor1 = 1;         //motorspeed 1  
        
        }
        else if(onoffsignal==0)
        {
        richting_motor1 = 0;    //motordirection (ccw)
        pwm_motor1 = 0;         //motorspeed 0
        
    }
        
    } 
        
}