//libraries
#include "mbed.h"
#include "HIDScope.h"
#include "BiQuad.h"  
#include "MODSERIAL.h"

//Define objects
AnalogIn    emg_biceps_right_in( A0 );              //analog in to get EMG in to c++
Ticker      sample_timer;                           //ticker
HIDScope    scope( 3);                              //open 3 channels in hidscope
DigitalOut richting_motor1(D4);     //motor1 direction output    
PwmOut pwm_motor1(D5);              //motor1 velocity  output
MODSERIAL pc(USBTX,USBRX);          //connection with computer
DigitalOut  led(LED_GREEN);         //include led
DigitalIn   button (D9);            //button 

//define variables

double emg_biceps_right;
double emg_filtered_high_biceps_right;
double emg_abs_biceps_right;
double emg_filtered_biceps_right;
int    onoffsignal=0;
double cut_off_value=0.20;
double max_right_biceps; 

BiQuad filterhigh(9.5654e-01,-1.9131e+00,9.5654e-01,-1.9112e+00,9.1498e-01);
BiQuad filterlow (6.2942e-06, 1.2588e-05,6.2942e-06,-1.9929e+00,9.9292e-01);

//functions which are called in ticker
void filter(){
        emg_biceps_right                = emg_biceps_right_in.read();                   //read the emg value from the electrodes
        emg_filtered_high_biceps_right  = filterhigh.step(emg_biceps_right);
        emg_abs_biceps_right            =fabs(emg_filtered_high_biceps_right);          //fabs because float
        emg_filtered_biceps_right       =filterlow.step(emg_abs_biceps_right);          //gefilterd met high, abs, low
        led=!led;
        
        if (emg_filtered_biceps_right>cut_off_value)
        {onoffsignal=1;}
          
        else 
        {onoffsignal=0;}
                      
        //send signals  to scope
        scope.set(0, emg_biceps_right );           //set emg signal to scope in channel 1
        scope.set(1, emg_filtered_biceps_right);    
        scope.set(2, onoffsignal);
        scope.send();                       //send all the signals to the scope
                }
                
void calibration(){
            if(button==0)
            {
            for(int n =0; n<2000;n++)                                                  //read for 5000 samples as calibration
                {
            emg_biceps_right=emg_biceps_right_in.read();                            //read the emg value from the elektrodes
            emg_filtered_high_biceps_right= filterhigh.step(emg_biceps_right);      //highpass
            emg_abs_biceps_right=fabs(emg_filtered_high_biceps_right);              //fabs because float
            emg_filtered_biceps_right=filterlow.step(emg_abs_biceps_right);         //lowpass to envelope
                        
            if (emg_filtered_biceps_right > max_right_biceps)                    //determine what the highest reachable emg signal is
                {
            max_right_biceps = emg_filtered_biceps_right;
                }
                }
            cut_off_value=0.2*max_right_biceps; 
            pc.printf(" change of cv %f ",cut_off_value );   
            }
                }
//program

int main()
{
pc.baud(115200); //start pc connection baudrate 115200

sample_timer.attach (&filter, 0.001)   //continously execute the EMG reader and filter, it ensures that filter and sampling is executed every 1/frequency seconds
sample_timer.attach (&calibration,0.001);    //continously execute callibration, only affects it when button is pressed for a while. 
//endless loop
    while(1) {
                
        if (onoffsignal==1)
        {
        richting_motor1 = 0;    //motordirection (ccw)
        pwm_motor1 = 1;         //motorspeed 1  
        
        }
        else if(onoffsignal==0)
        {
        richting_motor1 = 0;    //motordirection (ccw)
        pwm_motor1 = 0;         //motorspeed 0
        }
        
    }        
}