#include "mbed.h" //standaard bieb mbed
#include "QEI.h"  //bieb voor encoderfuncties in c++
#include "MODSERIAL.h" //bieb voor modserial
//alle ingangen definieren
DigitalIn encoder1A(D13); 
DigitalIn encoder1B(D12);
DigitalIn button_cw(D11);
DigitalIn button_ccw(D9);
DigitalOut ledcw(D10);
DigitalOut ledccw(D2);
DigitalOut motor1(D4);
PwmOut pwm_motor1(D5);
MODSERIAL pc(USBTX, USBRX);

//constanten
const int CW = 2.5; //definitie rechtsom 'lage waarde'
const int CCW =0; //definitie linksom 'hoge waarde'

//programma
int main ()
{
    pc.baud(115200); //contact maken met computer
    QEI Encoder(D12,D13, NC, 32);  // maakt een encoder aan! 
    int counts;                     //variabele counts aanmaken
    while(true)
    {
    if (button_cw==0)
        { //als knop is aan dan
        ledcw=1;
        motor1= CW;
        pwm_motor1=2.5;
        counts = Encoder.getPulses();
        pc.printf("encoder pulses: %i \r\n", counts);    
        float rondjes=counts/3200;                      
         pc.printf("encoder rondjes: %i \r\n", rondjes);    
        }
    else if (button_ccw==0)
        { ledccw=1;
        motor1= CCW;
        pwm_motor1=2.5;
        counts = Encoder.getPulses();
        pc.printf("encoder counts: %i \r\n", counts); 
        }    
    
    else { 
    ledcw=0; ledccw=0;
    pwm_motor1=0;
        }
    }
}