#include "mbed.h"
#include <string>

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"

//function protypes
char encrypt(char c);
void flashLights();

int main() {
    flashLights();
    //print to a file saved on the mbed mass storage device
    FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
    fprintf(fp, "Hello text doc World!");
    fclose(fp);

    //print some more
    fp = fopen("/local/out.txt", "a");  // Open "out.txt" on the local file system for writing, appending
    fprintf(fp, " log begins here: /n");
    fclose(fp);

    //print to the serial port, that requres an extra driver for xp
    Serial pc(USBTX, USBRX); // tx, rx
    pc.printf("Hello serial comms World!\n");

    bool commandIncoming=false;          //using a singal char to then expect a command char
    bool echoOn=true;                    //echo will eventually be output to the other USB port, and will be renamed pass through
    bool loggingOn=true;                 //log all the chars pressed to a text file
    bool encrypting=false;               //encrypting using the one time pad - exclude output chars * and others(todo: make a output map)
    char cOut;                           //the char being echod (or put out to the PC), is the cyphertext if encrypting is true
    char c;                              //the char coming in from the keyboard

    while (1) {

        //get a char from the keyboard (USB input)
        c = pc.getc();

        if (loggingOn) {
            fp = fopen("/local/out.txt", "a");  // Open "out.txt" on the local file system for writing, appending
            //todo: find a nicer way of doing this
            string s;
            s = c;
            fprintf(fp,"%s",s);
            fclose(fp);
        }
        //responsible for the output (at the moment to the serial comms, but eventually to the PC (USB output))
        if (c!='*'&&!commandIncoming && echoOn) {
            if (encrypting) {
                cOut = encrypt(c);
            } else {
                cOut = c;
            }
            pc.putc(cOut);
        }
        if (commandIncoming) {
            commandIncoming = false;
            //password recall
            if (c=='p') {
                pc.puts("default password");
            }
            //username recall
            if (c=='u') {
                pc.puts("default username");
            }
            //echo on/ off - debug (should be on all the time)
            if (c=='e') {
                if (echoOn==true) {
                    pc.puts("key echo off");
                    echoOn=false;
                    myled1 = 1;
                } else {
                    //when passing through myled1 is dim
                    pc.puts("key echo on");
                    echoOn=true;
                    myled1 = 0;
                }
            }
            //dump keylogged data (paste anywhere functionality)
            if (c=='d') {
                pc.puts("the data");
                //recall the last x keys pressed or pull data from the txt file
            }
            if (c=='l') {
                if (loggingOn==true) {
                    pc.puts("key logging off");
                    loggingOn=false;
                    //when loggingOn myled1 is dim
                    myled2 = 1;
                } else {
                    pc.puts("key logging on");
                    loggingOn=true;
                    myled2 = 0;
                }
            }
            if (c=='c') {
                if (encrypting==true) {
                    pc.puts("exiting the encryption mode");
                    encrypting = false;
                    //when encrypting myled3 is bright
                    myled3 = 0;
                } else {
                    pc.puts("entering the encryption mode - command keys are the same as before");
                    encrypting = true;
                    myled3 = 1;
                }
            }
        }
        //if the key is the start of a command, read the next key as a command (ie *p means output password)
        if (c== '*') {
            commandIncoming = true;
        }
    }
}

//eventually have this a one time pad, drawing chars from another file,
//deleting them as they go, and somehow having them not readable while in storage
char encrypt(char c) {
    return (c+1);
}

void flashLights() {
    //blink some lights
    myled1 = 1;
    wait(0.2);
    myled1 = 0;
    wait(0.2);

    myled1 = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;

    wait(0.2);
    myled1 = 0;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
}
