#ifndef TASK_MAIN_H
#define TASK_MAIN_H

#include "mbed.h"
#include "liboo/types.h"
#include "AppMain.h"
#include "AppLora.h"
#include "Button.h"
#include "Sensor.h"
#include "SensorManager.h"
#include "CommandSample.h"
#include "CommandSampleSelector.h"
//#include "Latch.h"

#include "Calendar.h"

#define COMMAND_COUNT 5
#define COMMAND_PAYLOAD_SIZE 255

#define DEBUG_MEMORY_START 2048
#define DEBUG_MEMORY_SIZE 128

using namespace liboo;
using namespace events;
class AppMain{
    public:
        typedef enum{
            GLOBAL_STATE_STOP,
            GLOBAL_STATE_JOIN,
            GLOBAL_STATE_RUN,
            GLOBAL_STATE_DISCONNECTING,
        }GLOBAL_STATE;

        typedef enum{
            EVENT_SHORT_PUSH,
            EVENT_LONG_PUSH,
            EVENT_JOIN_SUCCESS,
            EVENT_DISCONNECTED,
            EVENT_JOIN_FAILED,
            EVENT_CONNECTION_ERROR,
            EVENT_MINUTE_ELAPSED,
            EVENT_DAILY_SEND,

            EVENT_TX_DONE,
            EVENT_TX_ERROR,
            EVENT_RX_ERROR,
        }EVENT;

        typedef enum{
            RUN_STATE_READY,
            RUN_STATE_WAIT_SEND_COMPLETE,
        }RUN_STATE;

        static void initialize(EventQueue *queue);
        static void incoming_lora_message_callback(void);
        static void set_history_size(u8 history_size);


    private:
        AppMain(){}; // private constructor that prevent anyone from
                      // creating the instance
        static void _create_sensors(void);
        static void _button_callback_handler(Button::ACTION action);
        static void _lora_callback_handler(AppLora::EVENT event);
        static void _minute_elapsed_callback_handler(void);
        static void _daily_send_callback_handler(void);

        static void _global_event_handler_from_interrupt(AppMain::EVENT event);
        static void _global_event_handler(AppMain::EVENT event);
        static void _run_event_handler(AppMain::EVENT event);

        static void _minutes_elapsed(void);
        static void _enter_global_state_stop(void);
        static void _enter_global_state_join(void);
        static void _enter_global_state_run(void);
        static void _enter_global_state_disconnecting(void);
        static void _compute_random_number(void);
        static void _trigger_latch(bool sens);

        //debug
        static void _write_time(char* buffer);

        static s8 _send_empty(void);
        static void _scheduled_send(bool is_hourly_send);
        static s8 _send_samples(bool is_hourly_send);

        static SensorData _sensor_data;
        static Sensor *_sensor_array[CONFIG_SENSOR_COUNT];
        static CommandSample *_command_sample_array[COMMAND_COUNT];
        static u8 _command_payload[COMMAND_PAYLOAD_SIZE];
        static EventQueue *_queue;
        //static PCAL6416 *_gpio_exp;
        static LedBlinker *_led_blinker;
        static Button *_button;
        static SensorManager *_sensor_manager;
        static Calendar *_calendar;
        static MemoryDeviceEeprom *_memory_device_calendar;
        //static Latch *_latch;
        static CommandSampleSelector _command_selector;

        /*
        static SensorBattery *_sensor_battery;
        static SensorTensiometer *_sensor_tensiometer_1;
        static SensorTensiometer *_sensor_tensiometer_2;
        static SensorTensiometer *_sensor_tensiometer_3;
        static SensorPressure *_sensor_pressure_1;
        static SensorPressure *_sensor_pressure_2;
        static SensorPressure *_sensor_pressure_3;
        static SensorPressure *_sensor_pressure_pipe;
        static SensorSoilTemperature *sensor_soil_temperature;
        //static SensorBoardTempRH     *sensor_board_temp_rh;
        */

        static GLOBAL_STATE _global_state;
        static RUN_STATE _run_state;
        //static bool _forced_timestamp; // all frame must be timestamp until
                                       // the server answer
        //static bool _next_frame_timestamped;  // every day a frame
                                              // must be timestamped
        static u32 _daily_send_s;
        static u8 _remaining_join_tries;
        static u8 _remaining_sample_before_send; // number of time the sensor have
                                        // sampled. When this number reach 5
                                        // a transmition is scheduled
        static u8 _transmit_count_before_alternate; // every 6 transmit we
                                                    // must use alternate
                                                    // command
        static u8 _send_delay;
        static u8 _history_size;
        static char _time_buffer[24];

        static void _software_watchdog_increment();
        static void _software_watchdog_reset();
        static void _software_watchdog_enable();
        static void _software_watchdog_disable();
        static u8 _software_watchdog_time;
        static bool _software_watchdog_is_enable;

};

#endif

