#ifndef APP_COMMAND_H
#define APP_COMMAND_H

#include "CommandParser.h"
#include "SensorManager.h"
namespace liboo{
class AppCommand{
    public:

        /*
         *
         * Register all needed command callbacks into the command parser
         */
        static void configure(SensorManager* sensor_manager);

        static void process_command(u8 command_id, u8 *command_data,
                                    u16 command_size);

        static bool get_pump_state();
    protected:

        AppCommand(void){}

        static u16 _rtc_set_time(u8 command_id, u8* command_data,
                                            u16 command_data_size);

        static u16 _set_pump(u8 command_id, u8* command_data,
                                            u16 command_data_size);


        static CommandParser *_parser;
        static SensorManager *_sensor_manager;
        static bool _is_intialized;
        static bool _is_pump_on;

};
}
#endif

