#ifndef TASK_LORA_H
#define TASK_LORA_H

#include "mbed.h"
#include "liboo/types.h"
#include "tools.h"
#include "lorawan/system/lorawan_data_structures.h"

class AppLora{
    public:
        typedef enum{
            EVENT_DISCONNECTED,
            EVENT_CONNECTED,
            EVENT_TX_DONE,
            EVENT_RX_DONE,
            EVENT_UPLINK_REQUIERED,
            EVENT_TX_ERROR,
            EVENT_RX_ERROR,
            EVENT_CONNECTION_ERROR, // not network
            EVENT_JOIN_FAILURE  // wrong OTAA keys
        }EVENT;
        static void initialize(EventQueue *queue);
        static s16 get_rx_message(u8 *data, u16 data_size, u8 &app_port);
        static s16 send_message(u8 *data, u8 data_size, u8 app_port, bool confirmed);
        static void set_lora_callback(Callback<void(EVENT)> lora_callback);
        static void connect(void);
        static void disconnect(void);
        static u32 get_random(void);
        static u8 get_next_transmission_max_size(void);


    private:
        AppLora(){}; // private constructor that prevent anyone from
                      // creating the instance
        static void _send_empty_uplink(void);
        static void _enter_active_mode(void);
        static void _enter_lowpower_mode(void);
        static void _pin_active_mode(void);
        static void _pin_lowpower_mode(void);
        static void _lora_event_handler(lorawan_event_t event);
        static void _call_callback(EVENT lora_event);

        static Callback<void(EVENT)> _lora_callback;
        static events::EventQueue *_queue;
        static lorawan_app_callbacks_t _callbacks;
        static DigitalInOut _txco;
};

#endif

