#include "mbed.h" //Including the libraries for the code
#include "Small_7.h" //Including the libraries for the code
#include "Arial_9.h" //Including the libraries for the code
#include "C12832_lcd.h" //including the libraries for the code
#include "stdio.h" //Including the libraries for the code
#include "rtos.h" //Including the libraries for the code
#include "TextLCD.h" // Including the libraries for the code

DigitalOut LED_A(LED1); //Declaring I/O for the board
DigitalOut LED_B(LED2); //Declaring I/O for the board
DigitalOut LED_C(LED3); //Declaring I/O for the board
DigitalOut LED_D(LED4); //Declaring I/O for the board
DigitalIn Player1Input(p15); //Declaring I/O for the board
DigitalIn Player2Input(p12); //Declaring I/O for the board
DigitalIn PlayerCheck(p14); //Declaring I/O for the board
C12832_LCD LCD; 
Mutex LCD_Mutex;
Timer T;
PwmOut Speaker(p26); 
int Player1Points; //Declaration of variables - Variable tracks points for Player1
int Player2Points; //Declaration of variables - Variable tracks points for Player2
float Time1; //Declaration of variables - Variable tracks time system for Player1
float Time2; //Declaration of variables - Variable tracks time system for Player1
float FastestTime; //Declaration of variables - Variable tracks time system for fastest reaction time through the rounds
int Check=0; //Declaration of variables - Flags (Signals the function to run)
int Ready=0; //Declaration of variables - Flags (Signals the function to run)
int Player1Turn=0; //Declaration of variables - Flags (Signals the function to run)
int Player1Begin=0; //Declaration of variables - Flags (Signals the function to run)
int Player2Turn=0; //Declaration of variables - Flags (Signals the function to run)
int Player2Begin=0; //Declaration of variables - Flags (Signals the function to run)
int Scored=0; //Declaration of variables - scoring system for the rounds, allocation of points per round
int i=0; //Declaration of variables 
int Fast=0; //Declaration of variables - variable tracks which Player has fastest time 

void GameStart(void const *args){ //Defining a function 
    int i = 0; //Local variable
    for (i=0; i<1; i++) { //For loop which runs the code only for a single cycle
        LCD_Mutex.lock(); //Locks the LCD from other threads
        LCD.locate(36,10); //Locates the start position for the print statement
        LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
        LCD.printf("20001248"); //Prints text for student id number
        LCD_Mutex.unlock(); //Unlocks LCD to other threads
        wait(3); //Delay in seconds
        LCD_Mutex.lock(); //Locks the LCD from other threads
        LCD.locate(25,20); //Locates position for the print statement on the LCD
        LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
        LCD.printf("Reaction_2Player"); //Prints name of featured program
        LCD_Mutex.unlock(); //Unlocks the LCD to other threads
        wait(1); //Delay in seconds
        LED_A=1; //Turns LED 'ON' - (High = 1)
        Speaker.period(1.0/800.0); //Speaker frequency set to 800Hz
        Speaker = 0.05; //Duty cycle set to 5% - low range volume
        wait(0.05); //Delay in seconds
        Speaker = 0; //Turn 'OFF' speaker
        wait(0.3); //Delay in seconds
        LED_A=0; //Turns LED1 'OFF' - (Low = 0)
        LED_B=1; //Turns LED2 'ON' - (High = 1)
        Speaker.period(1.0/800.0); //Speaker frequency set to 800Hz
        Speaker = 0.05; //Duty cycle set to 5% - low range volume
        wait(0.05); //Delay in seconds
        Speaker = 0; //Turn 'OFF' speaker
        wait(0.3); //Delay in seconds
        LED_B=0; //Turns LED2 'OFF' - (Low = 0)
        LED_C=1; //Turns LED3 'ON' - (High = 1)
        Speaker.period(1.0/800.0); //Speaker frequency set to 800Hz
        Speaker = 0.05; //Duty cycle set to 5% - low range volume
        wait(0.05); //Delay in seconds
        Speaker = 0; //Turn 'OFF' speaker
        wait(0.3); //Delay in seconds
        LED_C=0; //Turns LED3 'OFF' - (Low = 0)
        LED_D=1; //Turns LED4 'ON' - (High = 1)
        Speaker.period(1.0/800.0); //Speaker frequency set to 800Hz
        Speaker = 0.05; //Duty cycle set to 5% - low range volume
        wait(0.05); //Delay in seconds
        Speaker = 0; //Turn 'OFF' speaker
        wait(0.3); //Delay in seconds
        LED_D=0; //Turns LED4 'OFF' - (Low = 0)
        wait(0.3); //Delay in seconds
        LED_A=1; //Turns LED1 'ON' - (High = 1)
        LED_B=1; //Turns LED2 'ON' - (High = 1)
        LED_C=1; //Turns LED3 'ON' - (High = 1)
        LED_D=1; //Turns LED4 'ON' - (High = 1)
        Speaker.period(1.0/800.0); //Speaker frequency set to 800Hz
        Speaker = 0.1f; //Duty cycle set to 1% - low range volume
        wait(0.05); //Delay in seconds
        Speaker = 0; //Turn 'OFF' speaker
        wait(0.3); //Delay in seconds
        LED_A=0; //Turns LED1 'OFF' - (Low = 0)
        LED_B=0; //Turns LED2 'OFF' - (Low = 0)
        LED_C=0; //Turns LED3 'OFF' - (Low = 0)
        LED_D=0; //Turns LED4 'OFF' - (Low = 0)
        LCD_Mutex.lock(); //Locks LCD from other threads
        LCD.locate(0,0); 
        LCD.cls(); //Clears LCD
        LCD_Mutex.unlock(); //Unlocks LCD to other threads
    }
}
void CheckThread(void const *args){ //Defining a function  
    while(true){ //While loop which runs thread
        if ((PlayerCheck) && (Check == 0)){ //Playercheck & check is the pressing of the joystick, if statement conditions are met it will run the code
                Ready = 1;
        }
    }
}
void Player1Go(void const *args){ //Defining a function
    while(true){ //While loop whichs runs thread
        if (Player1Turn == 1){ //If statement conditions are met it will run the code for Player1
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 5
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("5"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 4
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("4"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 3
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("3"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 2
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("2"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 1
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("1"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(0,0); 
            LCD.cls(); //Clears the LCD
            LCD_Mutex.unlock(); //Unlocks LCD to other threads
            LED_A=1; //Turns LED1 'ON' - (High = 1)
            T.start(); //Timer will start counting in seconds
            Player1Begin=1; //Flag variable is used to signal condition is met, i.e. to initialise Player1 turn
            Player1Turn=0; //Flag variable is used to signal condition is met, i.e. doesn't run IF statment if not required 
        }
    }
}
void Player1Action(void const *args){ //Defining a function
    while(true){ //While loop whichs runs thread
        if(Player1Input){ //Player1 presses joystick upward
            if (Player1Begin == 1){ //If statement which will run when certain conditions are met
                LED_A=0; //Turns LED4 'OFF' - (Low = 0)
                T.stop(); //Timer stops
                wait(0.01); //Delay in seconds
                Time1 = T.read(); //Timer will be stopped, and read to signify time in seconds
                if (Time1 < FastestTime);{ //Set new fastest time if condition is met
                    FastestTime = Time1;
                    Fast=1; //Player1 = Fastest Time
                }
                if (Time1 < 0.1){ //Scoring system for determing points for Player1 per round
                    Player1Points += 30;
                    Scored = 30;}
                else if ((Time1 < 0.15) && (Time1 > 0.1)){
                    Player1Points += 20;
                    Scored = 20;}
                else if ((Time1 < 0.25) && (Time1 > 0.15)){
                    Player1Points += 10;
                    Scored = 10;}
                else if ((Time1 < 0.5) && (Time1 > 0.25)){
                    Player1Points += 5;
                    Scored = 5;}
                else if ((Time1 < 1) && (Time1 > 0.5)){
                    Player1Points += 3;
                    Scored = 3;}
                else if ((Time1 < 3) && (Time1 > 1)){
                    Player1Points += 1;
                    Scored = 1;}
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(30,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Scored: %d",Scored); //Print points for Player1 for that round
                wait(2); //Delay in seconds
                LCD.locate(0,0); 
                LCD.cls(); //Clears LCD
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
                Player1Turn=0; //Ends Player1's turn
                Player1Begin=0; 
                T.reset();// Timer resets to zero
            }
        }
    }
}
void Player2Go(void const *args){// Defining a function
    while(true){ //While loop which runs thread
        if (Player2Turn == 1){ //If statement conditions are met it will run the code for Player2
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 5
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("5"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 4
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("4"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 3
            LCD.set_font((unsigned char*) Small_7); 
            LCD.printf("3"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 2
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("2"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(55,10); //Locates start position for the print statement, i.e. number 1
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("1"); //Prints statement onto LCD. Countdown from 5 in descending order to 1
            wait(1); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            LCD_Mutex.unlock(); //Unlocks LCD to other thread
            LED_A=1; //Turns LED1 'ON' - (High = 1)
            T.start(); //Timer will start counting in seconds
            Player2Begin=1; //Flag variable is used to signal condition is met, i.e. to initialise Player1 turn
            Player2Turn=0; //Flag variable is used to signal condition is met, i.e. doesn't run IF statment if not required 
        }
    }
}

void Player2Action(void const *args){
    while(true){ //While loop which runs thread
        if(Player2Input){ //Player1 presses joystick downward
            if (Player2Begin == 1){ //If statement which will run when certain conditions are met
                LED_A=0; //Turns LED1 'OFF' - (Low = 0)
                T.stop(); //Timer stops
                wait(0.01); //Delay in seconds
                Time2 = T.read(); //Timer will be stopped, and read to signify time in seconds
                if (Time2 < FastestTime);{ //Set new fastest time if condition is met
                    FastestTime = Time2;
                    Fast=2; //Player2 = Fastest Time
                }
                if (Time2 < 0.1){ //Scoring system for determing points for Player1 per round
                    Player2Points += 30;
                    Scored = 30;}
                else if ((Time2 < 0.15) && (Time2 > 0.1)){
                    Player2Points += 20;
                    Scored = 20;}
                else if ((Time2 < 0.25) && (Time2 > 0.15)){
                    Player2Points += 10;
                    Scored = 10;}
                else if ((Time2 < 0.5) && (Time2 > 0.25)){
                    Player2Points += 5;
                    Scored = 5;}
                else if ((Time2 < 1) && (Time2 > 0.5)){
                    Player2Points += 3;
                    Scored = 3;}
                else if ((Time2 < 3) && (Time2 > 1)){
                    Player2Points += 1;
                    Scored = 1;}
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(30,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Scored: %d",Scored); //Print points for Player2 for that round
                wait(2); //Delay in seconds
                LCD.locate(0,0);
                LCD.cls(); //Clears LCD
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
                Player2Turn=0; //Ends Player2's turn
                Player2Begin=0;
                T.reset(); //Timer resets to zero
            }
        }
    }
}
void MainGame(void const *args){ //Defining a function
    while(true){ //While loop which run thread
        wait(6); //Delay in seconds
        i = 0;
        for (i=1;i<4;i++){ //For loop repeats three times to signify three rounds of reaction game
            Check=1; //Flag variable is used to signal condition is met, i.e. sets checkthread conditions 
            while(Ready == 0){ //While loop will continue until joystick is pressed
                wait(0.5); //Delay in seconds
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(0,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Press Joystick In To Begin"); //Prints statement which is a command for the Player to begin the game
                wait(0.5); //Dlay in seconds
                LCD.locate(0,0);
                LCD.cls(); //Clears LCD
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            Ready=0; //Resets flag variable
            Check = 0; //Resets flag variable 
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            wait(0.1); //Delay in seconds
            LCD.locate(30,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Get Set, Ready..."); //Prints statement which is a que to let Players know the game is beginning
            wait(1); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clear LCD
            LCD_Mutex.unlock(); //Unlock LCD to other threads
            Player1Turn=1; //Flag variable for Player1
            wait(9); //Delay in seconds
            if ((Player1Begin == 1) && (T.read() > 3)){ //Reads timer constantly, and if timer reaches 3 seconds, the round will be forfeited as Player reaction is too slow
                T.stop(); //Timer stops
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(30,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Too slow"); //Prints statement to let Players know of forfeit 
                wait(1); //Delay in seconds
                LCD.locate(15,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Player 1 Round Lost"); //Prints statement to let Player know they lost the round
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
                Player1Begin=0; 
                Player1Turn=0;
                LED_A=0; //Turns LED1 'OFF' - (Low = 0)
                wait(1); //Delay in seconds
                T.reset(); //Timer resets
            }
            wait(0.1); //Delay in seconds
            Ready=0;
            Check=1; //Checkthread conditions
            while(Ready == 0){ //While loop whci runs thread. Will be infinite until joystick is pressed. Joysticks acts as an intterupt to this loop. 
                wait(0.5); //Delay in seconds
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(0,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Press Joystick In To Begin"); //Prints statement which is a command for Player to begin the game
                wait(0.5); //Delay in seconds
                LCD.locate(0,0);
                LCD.cls(); //Clears LCD
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            Ready=0; //Resets flag variable
            Check = 0; //Resets flag variable
            LCD_Mutex.lock(); //Locks LCD deom other threads
            LCD.locate(0,0); 
            LCD.cls(); //Clears LCD
            wait(0.1); //Delay in seconds
            LCD.locate(30,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Get Set, Ready..."); //Prints statement which is a que to let Players know the game is beginning
            wait(1); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            LCD_Mutex.unlock(); //Unlocks LCD to other threads
            Player2Turn=1; //Flag variable for Player2
            wait(9); //Delay in seconds
            if ((Player2Begin == 1) && (T.read() > 3)){ //Reads timer constantly, and if timer reaches 3 seconds, the round will be forfeited as Player reaction is too slow
                T.stop(); //Timer stops
                LCD_Mutex.lock(); //Locks LCD from other threads
                LCD.locate(30,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Too Slow"); //Prints statement to let Players know of forfeit
                wait(1); //Delay in seconds
                LCD.locate(15,10); //Locates start position for the print statement
                LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                LCD.printf("Player 2 Round Lost"); //Prints statement to let Player know they lost the round
                LCD_Mutex.unlock(); //Unlocks LCD to other threads
                Player2Begin=0; 
                Player2Turn=0;
                LED_A=0; //Turns LED1 'OFF' - (Low = 0)
                wait(1); //Delay in seconds
                T.reset(); //Timer resets
            }
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(15,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("The Results Of Round %d",i); //Prints statement to show points accumulated in the round
            wait(1); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD 
            wait(0.1); //Delay in seconds
            LCD.locate(30,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Player 1: %d",Player1Points); //Prints statement which shows Player1 points
            LCD.locate(30,20); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Player 2: %d",Player2Points); //Prints statement which shows Player2 points
            wait(2); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(30,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("After 3 rounds..."); //Prints statement of the total from the three rounds
            wait(1); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            wait(0.01); //Delay in seconds
            LCD.locate(10,0); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("The Fastest Reaction Time"); //Prints statement showing the fastest reaction time through the three rounds
            LCD.locate(20,10); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Was By Player %d",Fast); //Prints statement showing which Player got the the fastest reaction time
            LCD.locate(23,20); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("%f",FastestTime); //Prints statement - Fastest Time
            wait(3); //Delay in seconds
            LCD.locate(0,0);
            LCD.cls(); //Clears LCD
            LCD_Mutex.unlock(); //Unlocks LCD to other threads
            if (Player1Points > Player2Points){ //If Player1 has more points than Player2, the code will execute
                    LCD_Mutex.lock(); //Locks LCD from other threads
                    LCD.locate(20,10); //Locates start position for the print statement
                    LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                    LCD.printf("Congrats, Player 1 Wins"); //Prints statement congratulating winner (Player1)
                    LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            else if (Player2Points > Player1Points){ //If Player2 has more points than Player 1, the code will execute
                    LCD_Mutex.lock(); //Locks LCD from other threads
                    LCD.locate(20,10); //Locates start position for the print statement
                    LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                    LCD.printf("Congrats, Player 2 Wins"); //Prints statement congratulating winner (Player2)
                    LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            else if (Player1Points == Player2Points){ //If Player1 & Player2 have equal points, then the code will execute
                    LCD_Mutex.lock(); //Locks LCD from other threads
                    LCD.locate(30,10); //Locates start position for the print statement
                    LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
                    LCD.printf("It's A Draw!!"); //Prints statement to acknowledge draw between Player1 & Player2
                    LCD_Mutex.unlock(); //Unlocks LCD to other threads
            }
            LCD_Mutex.lock(); //Locks LCD from other threads
            LCD.locate(30,20); //Locates start position for the print statement
            LCD.set_font((unsigned char*) Small_7); //Setting of font size (small)
            LCD.printf("Well Done!"); //Prints statement to recognise the end of the game
            LCD_Mutex.unlock(); //Unlocks LCD to other threads
    }

}
    int main(){ //Defining a function
            Thread T1(GameStart); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T2(CheckThread); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T3(MainGame); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T4(Player1Go); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T5(Player1Action); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T6(Player2Go); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            Thread T7(Player2Action); //Threads runs constantly - (Threads are smalls sets of instructions which scedule and execute several functions at the same time.
            wait(99999); //Delay in seconds
            Thread::wait(1); 
}