#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "TextLCD.h"


EthernetNetIf eth;  
HTTPServer svr;

DigitalOut led1(LED1);
TextLCD lcd(p14, p15, p16, p17, p18, p19);

int main() {
  lcd.printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  lcd.printf("Setup OK\n");
  
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  lcd.printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
 
}