//  ELEC 2645 Project done by Damilola Akinbolu 
// A simple math trivia game designed to test your speed and ability
// to think on the fly
// There are 15 questions of VARYING difficulty and a timer as well
// Hope you enjoy it and good luck!!!!!!!

#include "mbed.h"
#include "ShiftReg.h"
#include "N5110.h"
//#include "platform/mbed_thread.h"
// Screen Display functions
N5110 lcd(p14,p8,p9,p10,p11,p13,p21); 
// BUTTON CONTROLS
DigitalIn button_A(p29);
DigitalIn button_B(p28);
DigitalIn button_C(p27);
DigitalIn button_D(p26);
ShiftReg shift;
// LED CONTROLS
// For some reason, the pins on my blue and red led are swapped.
DigitalOut blue_led(p24);
DigitalOut green_led(p23);
DigitalOut red_led(p22);
void Loading(); // Loading screen 
void Intro(); // Beginning statement in summary
void Testing(); // Basic instuctions
void Timing();  // Timer Notification
void buttons_off(); // Buttons 'not pressed' mode
void leds_off();  // Default mode: Leds off
void QuestionBank(); // Stores the questions
void FinalScore();   // Breakdown of scores
float x = 0.0;
float y = 0.0;
Timer t; // timer
int counter = 0;
void ScoreDisplay();
// QUESTIONS
void Q1();
void Q2();
void Q3();
void Q4();
void Q5();
void Q6();
void Q7();
void Q8();
void Q9();
void Q10();
void Q11();
void Q12();
void Q13();
void Q14();
void Q15();

int main()
{
    buttons_off(); 
    leds_off();
    lcd.init();
   
    shift.write(0x00);
    Loading();
    // PLAYER INSTRUCTIONS
    Intro();
    Testing();
    Timing();
    t.start(); // TIME STARTS  
    QuestionBank();
    t.stop(); // ENDING
    wait(2.000);
    FinalScore();
    ScoreDisplay();
    lcd.clear();  // clear buffer at the start of the loop
    
   

}





void QuestionBank()
{
    Q12();
    wait(1.500);
    Q9();
    wait(1.500);
    Q10();
    wait(1.500);
    Q13();
    wait(1.500);
    Q14();
    wait(1.500);
    Q8();
    wait(1.500);
    Q11();
    wait(1.500);
    Q3();
    wait(1.500);
    Q7();
    wait(1.500);
    Q1();
    wait(1.500);
    Q15();
    wait(1.500);
    Q2();
    wait(1.500);
    Q5();
    wait(1.500);
    Q6();
    wait(1.500);
    Q4();
}

void Q1()
{
        lcd.clear(); 
        
        while (1) {
            lcd.setContrast(0.8);
            lcd.printString("7 + 7 - 7 / 7?",0,0);
            lcd.printString("A. 14", 0,1);
            lcd.printString("B. 13", 0,2);
            lcd.printString("C. 1", 0,3);
            lcd.printString("D. 7", 0,4);
            lcd.refresh();
// ALL WRONG ANSWERS HAVE THE RED LED AND CORRECT HAVE THE GREEN AND A SCORE
// INCREMENT
         if (button_A.read() == 1) {
            red_led.write(0); 
            break; 
            
        } else if (button_B.read() == 1) {
            green_led.write(0); 
            counter++;  // CORRECT
            break; 
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}         
}  
}  

        
void Q2()
{
        lcd.clear();
        while (1) {
            lcd.setContrast(0.5);
            lcd.printString("45 OR 6?",0,0);
            lcd.printString("A. 51", 0,1);
            lcd.printString("B. 47", 0,2);
            lcd.printString("C. 46", 0,3);
            lcd.printString("D. 50", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
           
            red_led.write(0); 
            break;
        } else if (button_B.read() == 1) { 
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}        
}  
}         


void Q3()
{
        lcd.clear();
        
        while (1) {
            lcd.setContrast(0.5);
            lcd.printString("8/2(2+2)",0,0);
            lcd.printString("A. 1-1+1*1", 0,1);
            lcd.printString("B. 1", 0,2);
            lcd.printString("C. 156", 0,3);
            lcd.printString("D. 16", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0); 
            break;
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            green_led.write(0);
            counter++; // CORRECT
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}         
}  
}         


void Q4()
{
        lcd.clear(); // CLEARS THE SCREEN TO REMOVE PREVIOUS QUESTION
       
        while (1) {   
            lcd.printString("0, 1, 1, 2, 3",0,0);
            lcd.printString("13th Number?", 0,1);
            lcd.printString("A. 144", 0,2);
            lcd.printString("B. 12*11", 0,3);
            lcd.printString("C. 156", 0,4);
            lcd.printString("D. 142", 0,5);
            lcd.refresh();

         if (button_A.read() == 1) {
            green_led.write(0);
            counter++; // CORRECT
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0); 
            break; 
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}         
}  
}         


void Q5(){
        while(button_A.read() == 0) {
            leds_off();  // TURNS LEDS OFF   
            lcd.clear();
            lcd.setContrast(0.5);
            lcd.printString("1 + 3 = 5",0,0);
            lcd.printString("5 + 7 = 9", 0,2);
            lcd.printString("9 + 11 = 13", 0,4); // HINTS FOR SOLVING QUESTION
            // THE LONGER YOU TAKE MORE TIME ADDED
            lcd.printString("A TO CONTINUE", 0,5);
            lcd.refresh();
}        
            wait(0.500);
        
        while (1) {
            lcd.clear();
            lcd.printString("17 + 19 = ?", 0,0);
            lcd.printString("A. 23", 0,1);
            lcd.printString("B. 21", 0,2);
            lcd.printString("C. 25", 0,3);
            lcd.printString("D. 27", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}     
}  
}         


void Q6(){
        while(button_B.read() == 0) {
            leds_off();
            lcd.clear();
            lcd.setContrast(0.5);
            lcd.printString("12 * 12 = 9",0,0);
            lcd.printString("25 * 25 = 13", 0,2);
            lcd.printString("B TO CONTINUE", 0,5);
            lcd.refresh();    
}   
            wait(0.500);
        
        
        while (1) {
            lcd.clear();
            lcd.printString("31 * 31 = ?", 0,0);
            lcd.printString("A. 14", 0,1);
            lcd.printString("B. 17", 0,2);
            lcd.printString("C. 16", 0,3);
            lcd.printString("D. 15", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) { 
            green_led.write(0);
            counter++; 
            break;  // CORRECT
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}         
}  
}         

void Q7()
{
        lcd.clear();   
        
        while (1) {    
            lcd.printString("1 + 1 = ?", 0,0);
            lcd.printString("A. 2", 0,1);
            lcd.printString("B. 2", 0,2);
            lcd.printString("C. 2", 0,3);
            lcd.printString("D. 1345", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_B.read() == 1) { 
            green_led.write(0);
            counter++; // CORRECT
            break;
        } else if (button_C.read() == 1) { 
            green_led.write(0);
            counter++; 
            break;  // CORRECT
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}   
}  
}         


void Q8(){
        lcd.clear();
           
        while (1) {  
            lcd.printString("2187 * 4 = ?", 0,0);
            lcd.printString("A. 8478", 0,1);
            lcd.printString("B. 9478", 0,2);
            lcd.printString("C. NONE", 0,3);
            lcd.printString("D. 9748", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) {
            green_led.write(0);
            counter++; 
            break;  // CORRECT
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}       
}  
}      


void Q9(){
        while (button_C.read() == 0) {
            lcd.clear();
            leds_off();
            lcd.setContrast(0.5);
            lcd.printString("9 + B = 19",0,0);
            lcd.printString("+   +    +", 0,1);
            lcd.printString("A + 8 = 14", 0,2);
            lcd.printString("=   =    =", 0,3);
            lcd.printString("C + D =  E", 0,4);
            lcd.printString("C TO CONTINUE", 0,5);
            lcd.refresh();
}    

        wait(0.500);

        while (1) {
            lcd.clear();   
            lcd.printString(" A / B = ?", 0,0);
            lcd.printString("A. 6.8",0,1);
            lcd.printString("B. 0.61", 0,2);
            lcd.printString("C. 90", 0,3);
            lcd.printString("D. 0.6", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            green_led.write(0);
            counter++; // CORRECT 
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
         }     
    
    }  
}  
       

void Q10(){
        lcd.clear();
    
        while (1) { 
            lcd.printString("Make 1 from", 0,0);
            lcd.printString("C,D and E", 0,1);
            lcd.printString("A. (E-D)/C",0,2);
            lcd.printString("B. (C+D)/E", 0,3);
            lcd.printString("C. D-C-E", 0,4);
            lcd.printString("D. (E-C)/D", 0,5);
            lcd.refresh();

         if (button_A.read() == 1) {
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_B.read() == 1) { 
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_C.read() == 1) {
            red_led.write(0);
            break; 
        } else if(button_D.read() == 1){
            green_led.write(0);
            counter++; // CORRECT 
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}         
}  
}         


void Q11(){
        lcd.clear();
    
        while (1) {   
            lcd.printString("127 NAND 127", 0,0);
            lcd.printString("A. 127",0,1);
            lcd.printString("B. 1", 0,2);
            lcd.printString("C. 0", 0,3);
            lcd.printString("D. 128", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0); 
            break;
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) { 
            green_led.write(0);
            counter++;
            break;  // CORRECT 
        } else if(button_D.read() == 1){
            red_led.write(0); 
            break;
         } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}     
}  
}  
    


void Q12(){
        while (button_D.read() == 0) {    
            lcd.clear();
            leds_off();
            lcd.setContrast(0.8);
            lcd.printString("3   3   3",0,0);
            lcd.printString("4   6   8", 0,1);
            lcd.printString("5   8   11", 0,2);
            lcd.printString("6   7   8", 0,3);
            lcd.printString("?   9   8", 0,4);
            lcd.printString("D TO CONTINUE", 0,5);
            lcd.refresh();           
}
            wait(0.500);
    
    
        while (1) {   
            lcd.clear();        
            lcd.printString("What is ", 0,0);
            lcd.printString("the ? ", 0,1);
            lcd.printString("A. 9",0,2);
            lcd.printString("B. 11", 0,3);
            lcd.printString("C. 12", 0,4);
            lcd.printString("D. 10", 0,5);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break;
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if ( button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            green_led.write(0);
            counter++; // CORRECT
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}    
}  
}          
             

void Q13(){
        lcd.clear();
        while (1) {   
            lcd.printString("127 || 1? ", 0,0);
            lcd.printString("A. 1",0,1);
            lcd.printString("B. 127", 0,2);
            lcd.printString("C. 0", 0,3);
            lcd.printString("D. 128", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            green_led.write(0);
            counter++;
            break; // CORRECT
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) { 
            red_led.write(0);
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0); 
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}     
}  
}          
 
 
             
void Q14(){
        while (button_A.read() == 0) {
            lcd.clear();
            leds_off();
            lcd.setContrast(0.5);
            lcd.printString("If,",0,0);
            lcd.printString("A-A-A = 20", 0,1);
            lcd.printString("B-B-B = 15", 0,2);
            lcd.printString("C-C-C = 34", 0,3);
            lcd.printString("A TO CONTINUE", 0,5);
            lcd.refresh();
        
}

        wait(0.500);  
        
        while (1) { 
            lcd.clear();
            lcd.printString("What is ", 0,0);
            lcd.printString("A + B + C ", 0,1);
            lcd.printString("A. 69",0,2);
            lcd.printString("B. 60", 0,3);
            lcd.printString("C. -69", 0,4);
            lcd.printString("D. -60", 0,5);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);
            break; 
        } else if (button_B.read() == 1) { 
            red_led.write(0);
            break; 
        } else if (button_C.read() == 1) { 
            green_led.write(0);
            counter++; 
            break;  // CORRECT
        } else if(button_D.read() == 1){
             red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}                 
}  
}          
             
    void Q15(){
        while (button_B.read() == 0) {
            lcd.clear();
            leds_off();
            lcd.setContrast(0.5);
            lcd.printString("5 + 5 = 30",0,0);
            lcd.printString("6 + 6 = 42", 0,1);
            lcd.printString("7 + 7 = 56", 0,2);
            lcd.printString("8 + 8 = 72", 0,3);
            lcd.printString("B TO CONTINUE", 0,5);
            lcd.refresh();
}        
        
        wait(0.500);  
  
    
        while (1) {  
            lcd.clear();
            lcd.printString("10 + 10 = ?? ", 0,0);
            lcd.printString("A. 100",0,1);
            lcd.printString("B. 110", 0,2);
            lcd.printString("C. 101", 0,3);
            lcd.printString("D. 120", 0,4);
            lcd.refresh();

         if (button_A.read() == 1) {
            red_led.write(0);            
            break; 
        } else if (button_B.read() == 1) { 
            green_led.write(0);
            counter++; 
            break; // CORRECT
        } else if (button_C.read() == 1) { 
            red_led.write(0);            
            break;  
        } else if(button_D.read() == 1){
            red_led.write(0);
            break;
        } else {
             red_led.write(1);
             green_led.write(1);
             blue_led.write(1);
}     
    
}  
}          
             
void Loading() {
        while (x < 62) {
        lcd.clear();
        lcd.setContrast(0.8);
        lcd.printString("     MATH    ",0,1);
        lcd.printString("   TRIVIA!!!   ",0,2);
        lcd.drawRect(12,40,60,8,FILL_TRANSPARENT);
        lcd.drawRect(12,40,x,8,FILL_BLACK); 
        x+=2; // Rectangle fills to simulate loading
        lcd.refresh();
        wait(0.5);
}
}

void Intro() {
        while(button_A.read() == 0) {
            lcd.clear();
            lcd.printString(" Welcome  ", 0,0);
            lcd.printString("     to a ", 0,1);
            lcd.printString("challenging  ", 0,2);
            lcd.printString("    game ", 0,3);
            lcd.printString("A to continue", 0,5);
            lcd.refresh();   
}  
        wait(1.0);  
        
        while(button_B.read() == 0) {
            lcd.clear();
            lcd.printString(" that tests   ", 0,0);
            lcd.printString(" your mental ", 0,1);
            lcd.printString("math fortitude  ", 0,2);
            lcd.printString(" ...... ", 0,3);
            lcd.printString("B to continue", 0,5);
            lcd.refresh();   
} 
        wait(1.0); 
        
        while (button_C.read() == 0) {
            lcd.clear();
            lcd.printString("  Here we    ",0,1);
            lcd.printString("  gooo!!!!!   ",0,2);
            lcd.printString(" C to continue", 0,5);
            lcd.refresh();   
 
} 
}
        

void Testing(){
        lcd.clear();
        lcd.setContrast(0.5);
        lcd.printString("Before ",0,0);
        lcd.printString("we", 0,1);
        lcd.printString("start", 0,2);
        lcd.printString("...........", 0,3);
        lcd.refresh();
        wait(2.500);
        lcd.clear();
        
     while (1) {
            lcd.printString("An incorrect",0,0);
            lcd.printString("answer looks", 0,1);
            lcd.printString("like this..", 0,2);
            red_led = 0;
            lcd.refresh();
            wait(1.5);
            break;
}
     while(1) {
            lcd.clear();
            lcd.printString("A correct",0,0);
            lcd.printString("answer......", 0,1);
            green_led = 0;
            red_led = 1;
            lcd.refresh();
            wait(1.5);
            break;  
}   
}

void Timing()
{
    while(1) {
        lcd.clear();
        lcd.printString("Your time ",0,0);
        lcd.printString("starts now!", 0,1);
        wait(0.5);
        red_led = 0;
        green_led = 1;
        wait(0.7);
        red_led = 0;
        green_led = 0;
        wait(1.5);
        green_led = 0;
        red_led = 1;
        lcd.refresh();
        wait(1.5);
        break;  
}     
}


void FinalScore() {
            leds_off();
            lcd.clear();
 
            lcd.printString("Out of 15 your",0,0);
            lcd.printString("score is",0,1);
            
            char buffer[14]={0};  
            sprintf(buffer,"%d",counter); // SCORE OUT OF 15
            lcd.printString(buffer,0,2);
            lcd.refresh();           
           
        wait(2.0);
        
        
        while (1) {
           
           lcd.clear();
           lcd.printString("And the time",0,0);
           lcd.printString("..............",0,1);
           char buffer[14]={0};  
           sprintf(buffer,"%3f",t.read() - 22.5); // TOTAL TIME TAKEN
           lcd.printString(buffer,0,2);
           lcd.printString("seconds",0,3);
           lcd.refresh();      
           break;
        
}  
        wait(3.0);
        while (y < 62) {
           lcd.clear();
           lcd.printString("  Calculating   ",0,1);
           lcd.printString("  final scores  ",0,2);
           lcd.drawRect(12,40,60,8,FILL_TRANSPARENT);
           lcd.drawRect(12,40,y,8,FILL_BLACK);
           y+=2;
           lcd.refresh();
           wait(0.25);
}        
           wait(2.5);
           lcd.clear();
           lcd.printString("Your final ",0,0);
           lcd.printString(" score is",0,1);
           char score[14]={0};  
           sprintf(score,"%3f",counter + t.read() - 22.5); // TIME + SCORE
           lcd.printString(score,0,2);
           lcd.printString("POINTS",0,3);
           lcd.refresh();      

          
}

void ScoreDisplay() {
        int seven_seg_array [] = {
        0x3F,0x06,0x5B,0x4F,0x66,0x6D,0x7D,0x07,0x7F,0x67};
        int value = counter - 10;
        int new_array [] = {0x06,seven_seg_array [value]};
        // write 0 to 7-seg to turn it off
    
        while(1) { 
            if (counter < 10) {
                shift.write(seven_seg_array [counter]);
}
            else {
                for(int i = 0; i < 2; i++) {
                shift.write(new_array[i]);
                wait(0.75);
}
}
}
}


void buttons_off()
{
    // PCB has external pull-down resistors so turn the internal ones off
    // (default for DigitalIn)
    button_A.mode(PullNone);
    button_B.mode(PullNone);
    button_C.mode(PullNone);
    button_D.mode(PullNone);
}


void leds_off()
{
    // LEDs are common anode (active-low) so writing a 1 will turn them off
    red_led.write(1);
    green_led.write(1);
    blue_led.write(1);

    // SYNONYMS
    //red_led = 1;
    //green_led = 1;
    //blue_led = 1;
}                