//delay dsp for stm32f401re nucleo board with openmusiclabs audio codec shield.  Need to jumpter the i2c pins from the 
//top right arduino headers on the nucleo board to the bottom left 2 pins on the codec shield.  Bottom left i2c pins are
//not mbed enabled on the nucleo boards. 
//Also need to install a 11.2896MHz crystal on nucleo board and connect the appropriate jumpers as explained in the nucleo
//user manual.  Two 20pf capacitors are used with the crystal.  The series resistors going from the crystal to the stm32 chip
//are just shorts.   
//Preceed audio path with a 1/47 voltage divider and follow with a 47X inverting op amp to bring up to eurorack levels.  Use DC
//blocking cap after the op amp.
//Note that this is setup for the left input only and drives both outputs.  It is easy to modify the code for stereo effects
//and both inputs.  

//June 2015..
//Added interpolation so it acts more like a bbd or tape delay.  It is easy to switch between cosine and linear interpolation.
//Cubic interpolation might be a possibility if I can figure out how it works.
//Added a nice lowpass filter class.  Might want to put the delay in a class like this for reverb work.  Need to make an oscillator next.

#define DELAYLEN        2900        //24,000 is about as far as you can go in the ram.
#define SAMPLINGFREQ    22          //roughly the smapling frequency in KHz.  options are 22,29,44,88 for 22khz,29khz,etc..

#include "mbed.h"
#include "dsp.h"
#include "allpass.h"
#include "codec.h"
#include "osc.h"
 
SPI spi(SPI_MOSI,SPI_MISO,SPI_SCK);
Ticker timer;
Ticker timer2;
AnalogIn analog_value(A1);          //delay time pot
AnalogIn analog_value2(A0);         //feedback amount pot
DigitalOut cs(D10);

int left_out = 0, right_out = 0, left_out_u = 0, right_out_u = 0, left_in = 0, right_in = 0,
index1 = 0, index2 = (DELAYLEN*0.99), index3 = (DELAYLEN*0.99);
uint16_t left_in_u = 0, meas = 0, measprev = 0;
float left_in_f = 0, feedback = 0, feedback2 = 0, feedback3 = 0, offset = 10.0,
meas2f = 0.5, damping = 0, damping2 = 0, damping3 = 0, modL = 0, modL2 = 0, modL3 = 0, modL4, modR = 0, modR2 = 0, modR3 = 0, modR4, 
modLos = 0, modL2os = 0, modL3os = 0, modL4os = 0, modRos = 0, modR2os = 0, modR3os = 0, modR4os = 0,
upperLim, lowerLim,
left_out_f = 0, right_out_f = 0;
float left_out_2 = 0, right_out_2 = 0, left_out_3 = 0, right_out_3 = 0, left_out_4 = 0, right_out_4 = 0, loopfb = 0, loopfb2 = 0;
float audioFeedbackRight,audioFeedbackLeft;

float LPdampingFreq = 11000, HPdampingFreq = 100;  //some parameters you might want to adjust.
int   LPdampingPoles = 2, HPdampingPoles = 0;       //I don't think the highpass is quite working.

OnePoleLp feedbackFilter;
OnePoleLp lengthFilter;
OnePoleLp dampingFilter;
AllPass delayLeft;
AllPass delayLeft2;
AllPass delayLeft3;
AllPass delayLeft4;
AllPass delayRight;
AllPass delayRight2;
AllPass delayRight3;
AllPass delayRight4;
gsOsc OscillatorL;
gsOsc OscillatorL2;
gsOsc OscillatorL3;
gsOsc OscillatorL4;
gsOsc OscillatorR;
gsOsc OscillatorR2;
gsOsc OscillatorR3;
gsOsc OscillatorR4;

void I2S_send(void){
    cs.write(0);                                //0 for left output
    left_in = spi.write(left_out);
    cs.write(1);                                //1 for right output
    right_in = spi.write(right_out);
    
    left_in_f = intToFloat(left_in);
    
    /////////////////////////////////////////dsp part//////////////////////////////////////////////////////////////////////
        
    ///*    
    //process control signals
    feedback2 = feedbackFilter.process(feedback);
    //maybe move this to the dac sampling interrupt.  seems like there was a reason it's here though.
    //damping2 = lengthFilter.process(damping);
    //damping3 = lengthFilter.process(damping2);
    //damping3 *= (5000);                       //make about 10k the max cutoff for damping

    //dampingFilter.setFc(damping3/(SAMPLINGFREQ*1000));

    //process audio.   probably calculate these coefficients elsewhere so you don't do the multiply all the time.
    //left delay mod   
    modL =  modLos +  OscillatorL.process(1);
    modL2 = modL2os + OscillatorL2.process(1);
    modL3 = modL3os + OscillatorL3.process(1);
    modL4 = modL4os + OscillatorL3.process(0);
    //right delay mod
    modR =  modRos +  OscillatorR.process(0);
    modR2 = modR2os + OscillatorR2.process(0);
    modR3 = modR3os + OscillatorR3.process(1);
    modR4 = modR4os + OscillatorR4.process(1);
    
    if(modL > upperLim)
        modL = upperLim;
    if(modL < lowerLim)
        modL = lowerLim;
    if(modL2 > upperLim)
        modL2 = upperLim;
    if(modL2 < lowerLim)
        modL2 = lowerLim;
    if(modL3 > upperLim)
        modL3 = upperLim;
    if(modL3 < lowerLim)
        modL3 = lowerLim;
    if(modL4 > upperLim)
        modL4 = upperLim;
    if(modL4 < lowerLim)
        modL4 = lowerLim;
    if(modR > upperLim)
        modR = upperLim;
    if(modR < lowerLim)
        modR = lowerLim;
    if(modR2 > upperLim)
        modR2 = upperLim;
    if(modR2 < lowerLim)
        modR2 = lowerLim;
    if(modR3 > upperLim)
        modR3 = upperLim;
    if(modR3 < lowerLim)
        modR3 = lowerLim;
    if(modR4 > upperLim)
        modR4 = upperLim;
    if(modR4 < lowerLim)
        modR4 = lowerLim;

    left_out_2 = delayLeft2.process(satAdd(left_in_f,loopfb),.3,modL);
    left_out_3 = delayLeft3.process(left_out_2,.4,modL2);
    left_out_4 = delayLeft4.process(left_out_3,.4,modL3);
    left_out_f = delayLeft.process(left_out_4,.4,modL4);
    right_out_2 = delayRight2.process(satAdd(left_in_f,loopfb2),.3,modR);
    right_out_3 = delayRight3.process(right_out_2,.4,modR2);
    right_out_4 = delayRight4.process(right_out_3,.4,modR3);
    right_out_f = delayRight.process(right_out_4,.4,modR4);

    loopfb2 = left_out_f*feedback2;                     //swizzle the feedbacks left to right
    loopfb = right_out_f*feedback2;      
    
    //apply damping
    //loopfb = dampingFilter.process(loopfb);
    //loopfb2 = dampingFilter.process(loopfb2);
    //*/
    //left_out_f = left_in_f;
    //right_out_f = left_in_f;
    
    left_out_u = left_out_f;
    right_out_u = right_out_f;

    /////////////////////////////////////////end of dsp part/////////////////////////////////////////////////////////////////
    
    left_out = unsignedToSigned(left_out_u);
    right_out = unsignedToSigned(right_out_u);

}

void analog_read(void){
    //this is the stuff for the feedback amount pot
    meas2f = analog_value2.read_u16();          //converts unint16 value to float
    feedback = meas2f/4100;                     //now you have a value between 0 and 1 that will control the feedback amount.
    feedback *= feedback;
    
    //this is the stuff for the delay time pot
    meas = 4096 - analog_value.read_u16();      //values go from 1 to 4095
    //if(abs(meas - measprev) > 5){
        measprev = meas;
        damping = meas;
        damping /= 4200;                              //this number took some tweaking.
        damping *= damping;
    //}
}

int main(){
    
    //set up baud rate for 11.2MHz crystal
    pc.baud(.7*9600*2);
    wait(.1);
    
    //do I2C transfter to initialize codec
    codecInit();
    
    //initialize fixed filters
    double feedbackCutoff = 10.0/(SAMPLINGFREQ*1000);       //adjust these cutoffs according to taste.
    feedbackFilter.setFc(feedbackCutoff);
    double lengthCutoff = 3.0/(SAMPLINGFREQ*1000);
    lengthFilter.setFc(lengthCutoff);
    
    //initize oscillators and mod offsets
    modLos = DELAYLEN*.74;
    modL2os = DELAYLEN*.43;
    modL3os = DELAYLEN*.33; 
    modL4os = DELAYLEN*.37;
    OscillatorL.setF(.53,DELAYLEN/66);
    OscillatorL2.setF(.03,DELAYLEN/65);
    OscillatorL3.setF(.02,DELAYLEN/78);
    OscillatorL4.setF(.023,DELAYLEN/78);
    //right delay mod
    modRos = DELAYLEN*.75;
    modR2os = DELAYLEN*.49;
    modR3os = DELAYLEN*.33;
    modR4os = DELAYLEN*.37;
    OscillatorR.setF(.51,DELAYLEN/69);
    OscillatorR2.setF(.03,DELAYLEN/67);
    OscillatorR3.setF(.02,DELAYLEN/78);
    OscillatorR4.setF(.023,DELAYLEN/78);
    upperLim = .9*DELAYLEN;
    lowerLim = .05*DELAYLEN;

    //set up I2S
    spi.frequency(4e6*2);                         //8MHz spi.  This is fast enough for 88KHz 16 bit sampling.
    spi.format(16,0);                           //16 bit.  clock polarity 0, phase 0.
    wait(.1);
    
    //audio rate timers.   29 and 44 are not very good.  Might want to use an external clock for the Nucleo.  
    if(SAMPLINGFREQ == 22)
        timer.attach(&I2S_send,32e-6);          //22KHz sampling.           12.2008MHz/512 = 21.876KHz.  1/(21.876KHz(8/11.2008)) = 64e-6 Sec and / by 2 because the codec divides by to before sending the osc out.
    if(SAMPLINGFREQ == 29)
        timer.attach(&I2S_send,24e-6);          //29.168KHz sampling.       11.2008MHz/384 = 19.168KHz.  1/(29.168KHz(8/11.2008)) = 48.0012e-6 Sec and / by 2 because the codec divides by to before sending the osc out.
    if(SAMPLINGFREQ == 44)    
        timer.attach(&I2S_send,16.0e-6);        //44.1KHz sampling.         almost exactly 32e-6 and then divide by 2.  Doesn't sound right yet.
    if(SAMPLINGFREQ == 88)
        timer.attach(&I2S_send,8e-6);       //88KHz sampling.   Need to calculate.
    
    //control signal timer
    timer2.attach(&analog_read,50e-3);
    
    //go!
    while(1){}
}