#include "mbed.h"
#include "EthernetInterface.h"
#include "M2XStreamClient.h"
#include "MODSERIAL.h"

//function declaration
void TimerRead(void);
void MotionSense(void);
void motiontrigger(void);
void ledbounce(void);
void RxRead(void);
void motionTimeOut(void);
void streamData(void);
void SecurityCam(void);
void SecurityEnable(void);

//bluetooth variables
bool btflag = false;
char received[256] = {""};
int i = 0;
//led variables
int led_total = 0;
int led_session = 0;
bool ledtimerflag = false;
DigitalOut led(LED_RED);
//fan variables
int fan_total = 0;
int fan_session = 0;
bool fantimerflag = false;
PwmOut fan(D3);
//Motion Sensor Variables
InterruptIn motionsensor(D2);
DigitalOut motionsensorpwr(D1, 0);
//Motion Sensor Timeout
Timeout motionTimeout;
//Timers Initialization
Timer ledtimer;
Timer fantimer;
// Initialize Serial port
Serial pc(USBTX, USBRX);
//bluetooth module declaration
MODSERIAL HC05(PTC15, PTC14);
//security camera 
DigitalOut securitycam(D5, 0);
bool securityflag = false;

int ret;
// Set Sensor Stream details
char deviceId[] = "56429e7da76e7b0d282164231db3446e"; // Device you want to push to
char streamtime[] = "Time"; // Stream you want to push to
char streamfan[] = "Fan_Time";
char m2xKey[] = "3f3543d74e384a4c94d71729ffee9277"; // Your M2X API Key or Master API Key
// Initialize the M2X client
Client client;
M2XStreamClient m2xClient(&client, m2xKey);
Ticker streamticker;

void rxinterrupt(MODSERIAL_IRQ_INFO *q) 
{
    btflag = true;
    return;
}

int main()
{
motionsensor.disable_irq();
// Intialize Ethernet connection

EthernetInterface eth;
eth.init();
eth.connect();
printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());


//initialize bluetooth
HC05.baud(9600);

//attach interrupts
HC05.attach(&rxinterrupt, MODSERIAL::RxIrq);
motionsensor.rise(&motiontrigger);
//streamticker.attach(&streamData,1.0);

led.write(1); //led initialized to off 

pc.printf("Program Begins.");
    while (1) 
    {    
        RxRead();
        streamData();
        wait_ms(100);
    }     
            
}

void streamData()
{
        ret = m2xClient.updateStreamValue(deviceId, streamtime, led_total);
        pc.printf("send() returned %d\r\n", ret);
        ret = m2xClient.updateStreamValue(deviceId, streamfan, fan_total);
        pc.printf("send() returned %d\r\n", ret);
}

void RxRead(void)
{
        if(btflag && !HC05.rxBufferEmpty() && HC05.rxGetLastChar() == '#')
    {
        HC05.move(received, 256);
        pc.printf("%c%c%c%c%c",received[0], received[1], received[2],received[3], received[4]); 
        wait_ms(5);
        if(received[0] == 'L')
        {
            if(received[2] ==  'N')
            {
                led = 0; // toggle led
                ledtimerflag = true;
            }
            else if(received[2] == 'F')
            {
                led = 1;
                ledtimerflag = false;
            }
        }
        else if (received[0] == 'F')
        {
            if(received[3] == 'H')
            {
                fan.write(0.99);
                fantimerflag = true;
            }
            else if(received[3] == 'L')
            {
                fan.write(0.6);
                if(!fantimerflag)
                fantimerflag = true;
            }
            else if(received[3] == 'O')
            {
                fan.write(0.0);
                fantimerflag = false;
            }
        }
        else if(received[0] == 'M')
        {
            if(received[1] == 'R')
            {
                motionsensor.disable_irq();
            }
            else if(received[1] == 'E')
            {
                led = 1; //led off
                fan.write(0.0); //fan off
                MotionSense();
            }
            else if(received[1] == 'S')
            {
                securityflag = true;
                SecurityEnable();
            }
        }              
        btflag = false;
        
        if(fantimerflag)
        {
        fantimer.start();
        }
        else 
        {
        fantimer.stop();
        fan_session = fantimer.read(); //reads the session time
        fan_total += fan_session; // accumulates to total time
        fantimer.reset();
        }
        
        if(ledtimerflag)
        {
        ledtimer.start();
        }
        else 
        {
        ledtimer.stop();
        led_session = ledtimer.read(); //reads the session time
        led_total += led_session; // accumulates to total time
        ledtimer.reset();
        }
    }
}
void TimerRead()
{
    pc.printf("LED Session Time: %d", led_session);   
    pc.printf("\r\nTotal LED Time: %d\r\n", led_total);
    pc.printf("Fan Session Time: %d", fan_session);   
    pc.printf("\r\nTotal Fan Time: %d\r\n", fan_total);
}

void MotionSense()
{
    HC05.puts("Motion Sensor Initializing...");
    ledbounce();
    HC05.puts("Enabled.");
    motionsensor.enable_irq();
}

void SecurityEnable()
{
    HC05.puts("Security Initializing...");
    ledbounce();
    HC05.puts("Enabled.");
    motionsensor.enable_irq();
}

void SecurityCam()
{
    securitycam = 1;
    wait_ms(50);
    securitycam = 0;      
}

void motiontrigger()
{
    led = 0;
    //security mode sends pulse to start python script
    if(securityflag)
    {
        SecurityCam();
        securityflag = false; //resets flag
    }
    else
    motionTimeout.attach(&motionTimeOut,10.0);
}

void motionTimeOut()
{
        led = 1; //led off;
}        

void ledbounce()
{
    for( int i = 0; i < 20; i++)
    {
    led = led ^1;
    wait_ms(100);
    }
    led = 1;
}


/*#include "mbed.h"
#include "EthernetInterface.h"
#include "M2XStreamClient.h"
#include "MODSERIAL.h"

//function declaration
void TimerRead(void);
void MotionSense(void);
void motiontrigger(void);
void ledbounce(void);
void RxRead(void);
void motionTimeOut(void);
void streamData(void);
void SecurityCam(void);
void SecurityEnable(void);

//bluetooth variables
bool btflag = false;
char received[256] = {""};
int i = 0;
//led variables
int led_total = 0;
int led_session = 0;
bool ledtimerflag = false;
DigitalOut led(LED_RED);
//fan variables
int fan_total = 0;
int fan_session = 0;
bool fantimerflag = false;
PwmOut fan(D3);
//Motion Sensor Variables
InterruptIn motionsensor(D2);
DigitalOut motionsensorpwr(D1, 0);
//Motion Sensor Timeout
Timeout motionTimeout;
//Timers Initialization
Timer ledtimer;
Timer fantimer;
// Initialize Serial port
Serial pc(USBTX, USBRX);
//bluetooth module declaration
MODSERIAL HC05(PTC15, PTC14);
//security camera 
//DigitalOut securitycam(D5, 0);
bool securityflag = false;

int ret;
// Set Sensor Stream details
char deviceId[] = "56429e7da76e7b0d282164231db3446e"; // Device you want to push to
char streamtime[] = "Time"; // Stream you want to push to
char streamfan[] = "Fan_Time";
char m2xKey[] = "3f3543d74e384a4c94d71729ffee9277"; // Your M2X API Key or Master API Key
// Initialize the M2X client
Client client;
M2XStreamClient m2xClient(&client, m2xKey);
Ticker streamticker;

void rxinterrupt(MODSERIAL_IRQ_INFO *q) 
{
    btflag = true;
    return;
}

int main()
{
motionsensor.disable_irq();
// Intialize Ethernet connection

EthernetInterface eth;
eth.init();
eth.connect();
printf("Success. Connected!. Device IP Address is %s\r\n", eth.getIPAddress());


//initialize bluetooth
HC05.baud(9600);

//attach interrupts
HC05.attach(&rxinterrupt, MODSERIAL::RxIrq);
motionsensor.rise(&motiontrigger);
//streamticker.attach(&streamData,1.0);

led.write(1); //led initialized to off 

pc.printf("Program Begins.");
    while (1) 
    {    
        RxRead();
        streamData();
        wait_ms(100);
    }     
            
}

void streamData()
{
        ret = m2xClient.updateStreamValue(deviceId, streamtime, led_total);
        pc.printf("send() returned %d\r\n", ret);
        ret = m2xClient.updateStreamValue(deviceId, streamfan, fan_total);
        pc.printf("send() returned %d\r\n", ret);
}

void RxRead(void)
{
        if(btflag && !HC05.rxBufferEmpty() && HC05.rxGetLastChar() == '#')
    {
        HC05.move(received, 256);
        pc.printf("%c%c%c%c%c",received[0], received[1], received[2],received[3], received[4]); 
        wait_ms(5);
        if(received[0] == 'L')
        {
            if(received[2] ==  'N')
            {
                led = 0; // toggle led
                ledtimerflag = true;
            }
            else if(received[2] == 'F')
            {
                led = 1;
                ledtimerflag = false;
            }
        }
        else if (received[0] == 'F')
        {
            if(received[3] == 'H')
            {
                fan.write(0.99);
                fantimerflag = true;
            }
            else if(received[3] == 'L')
            {
                fan.write(0.6);
                if(!fantimerflag)
                fantimerflag = true;
            }
            else if(received[3] == 'O')
            {
                fan.write(0.0);
                fantimerflag = false;
            }
        }
        else if(received[0] == 'M')
        {
            if(received[1] == 'R')
            {
                motionsensor.disable_irq();
            }
            else if(received[1] == 'E')
            {
                led = 1; //led off
                fan.write(0.0); //fan off
                MotionSense();
            }
        }              
        btflag = false;
        
        if(fantimerflag)
        {
        fantimer.start();
        }
        else 
        {
        fantimer.stop();
        fan_session = fantimer.read(); //reads the session time
        fan_total += fan_session; // accumulates to total time
        fantimer.reset();
        }
        
        if(ledtimerflag)
        {
        ledtimer.start();
        }
        else 
        {
        ledtimer.stop();
        led_session = ledtimer.read(); //reads the session time
        led_total += led_session; // accumulates to total time
        ledtimer.reset();
        }
    }
}
void TimerRead()
{
    pc.printf("LED Session Time: %d", led_session);   
    pc.printf("\r\nTotal LED Time: %d\r\n", led_total);
    pc.printf("Fan Session Time: %d", fan_session);   
    pc.printf("\r\nTotal Fan Time: %d\r\n", fan_total);
}

void MotionSense()
{
    HC05.puts("Motion Sensor Initializing...");
    ledbounce();
    HC05.puts("Enabled.");
    motionsensor.enable_irq();
}

void motiontrigger()
{
    led = 0;
    motionTimeout.attach(&motionTimeOut,10.0);
}

void motionTimeOut()
{
        led = 1; //led off;
}        

void ledbounce()
{
    for( int i = 0; i < 20; i++)
    {
    led = led ^1;
    wait_ms(100);
    }
    led = 1;
}*/
