#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPServer.h"
#include "HTTPClient.h"
#include "mbed_rpc.h"

Timer timer_tf;

Serial pc(USBTX, USBRX);

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

//T1
DigitalOut t1red(p5);
DigitalOut t1yellow(p6);
DigitalOut t1green(p7);
//T2
DigitalOut t2red(p11);
DigitalOut t2yellow(p12);
DigitalOut t2green(p13);
//T3
DigitalOut t3red(p18);
DigitalOut t3yellow(p19);
DigitalOut t3green(p17);
//pin 20 cannot use for led

void t1light(char a){
        t1red = 0;
        t1yellow = 0;
        t1green = 0;    
    if (a == 'R'){
        t1red = 1;
        t1yellow = 0;
        t1green = 0;
    }else if(a == 'Y'){
        t1red = 0;
        t1yellow = 1;
        t1green = 0;
    }else if(a == 'G'){
        t1red = 0;
        t1yellow = 0;                                                 
        t1green = 1;
    }else{
        t1red = 0;
        t1yellow = 0;
        t1green = 0;    
    } 
}

void t2light(char a){
        t2red = 0;
        t2yellow = 0;
        t2green = 0;    
    if (a == 'R'){
        t2red = 1;
        t2yellow = 0;
        t2green = 0;
    }else if(a == 'Y'){
        t2red = 0;
        t2yellow = 1;
        t2green = 0;
    }else if(a == 'G'){
        t2red = 0;
        t2yellow = 0;
        t2green = 1;
    }else{
        t2red = 0;
        t2yellow = 0;
        t2green = 0;    
    } 
}

void t3light(char a){
        t3red = 0;
        t3yellow = 0;
        t3green = 0;        
    if (a == 'R'){
        t3red = 1;
        t3yellow = 0;
        t3green = 0;
    }else if(a == 'Y'){
        t3red = 0;
        t3yellow = 1;
        t3green = 0;
    }else if(a == 'G'){
        t3red = 0;
        t3yellow = 0;
        t3green = 1;
    }else{
        t3red = 0;
        t3yellow = 0;
        t3green = 0;    
    } 
}

void traffic_timer (char t1, char t2, char t3){
    t1light(t1);
    t2light(t2);
    t3light(t3);
    }


void http_get(){
    char* Server = "http://192.168.1.103/PDRM/api/api_update.php";
    char buffer[256];
    HTTPClient http;
    
    buffer[0] = 0;
    sprintf(buffer,"%s?t1=%d,%d,%d&t2=%d,%d,%d&t3=%d,%d,%d",Server,t1red.read(),t1yellow.read(),t1green.read(),t2red.read(),t2yellow.read(),t2green.read(),t3red.read(),t3yellow.read(),t3green.read());
    printf("Send to %s\r\n", buffer);
    http.get(buffer, buffer , 10); // Execute the URL of urlBuffer
}

void traffic_interrupt (char t1, char t2, char t3, int time){
    t1light(t1);
    t2light(t2);
    t3light(t3);
    http_get();
    wait(time);  
    }  

void interrupt(Arguments *in, Reply *out);
RPCFunction rpcMove(&interrupt, "Interrupt");
int duration,Id;


void interrupt(Arguments *in, Reply *out){
    Id = in->getArg<int>();
    duration = in->getArg<int>();
    pc.printf("Traffic Light %d will turn to green for %d seconds\r\n", Id, duration);
    
    switch(Id){
        case 1 :
        led1 = 1;
        timer_tf.stop();
        if(timer_tf.read() >= 0 && timer_tf.read() <= 51){
        wait(duration);
        }else if(timer_tf.read() >= 52 && timer_tf.read() <= 90){
        traffic_interrupt('R','Y','R',3);
        traffic_interrupt('G','R','R',duration);
        traffic_interrupt('Y','R','R',3);
        }else if(timer_tf.read() >= 91 && timer_tf.read() <= 94){
        wait(3);
        traffic_interrupt('G','R','R',duration);
        traffic_interrupt('Y','R','R',3);
        }else if(timer_tf.read() >= 95 && timer_tf.read() <= 165){
        traffic_interrupt('R','R','Y',3);
        traffic_interrupt('G','R','R',duration);    
        traffic_interrupt('Y','R','R',3);    
        }else if(timer_tf.read() >= 166 && timer_tf.read() <= 169){
        wait(3);
        traffic_interrupt('G','R','R',duration);
        traffic_interrupt('Y','R','R',3);
        }
        led1 = 0;
        timer_tf.start();   
        break;
          
        case 2 :
        led2 = 1;
        timer_tf.stop();
        if(timer_tf.read() >= 0 && timer_tf.read() <= 47){
        traffic_interrupt('Y','R','R',3);
        traffic_interrupt('R','G','R',duration);
        traffic_interrupt('R','Y','R',3);
        }else if(timer_tf.read() >= 48 && timer_tf.read() <= 51){
        wait(3);
        traffic_interrupt('R','G','R',duration);
        traffic_interrupt('R','Y','R',3);
        }else if(timer_tf.read() >= 52 && timer_tf.read() <= 94){
        wait(duration);
        }else if(timer_tf.read() >= 95 && timer_tf.read() <= 165){
        traffic_interrupt('R','R','Y',3);
        traffic_interrupt('R','G','R',duration);
        traffic_interrupt('R','Y','R',3);
        }else if(timer_tf.read() >= 166 && timer_tf.read() <= 169){
        wait(3);
        traffic_interrupt('R','G','R',duration);
        traffic_interrupt('R','Y','R',3);
        }
        led2 = 0;
        timer_tf.start(); 
        break;
        
        case 3 :
        led3 = 1;
        timer_tf.stop();
        if(timer_tf.read() >= 0 && timer_tf.read() <= 47){
        traffic_interrupt('Y','R','R',3);
        traffic_interrupt('R','R','G',duration);
        traffic_interrupt('R','R','Y',3);
        }else if(timer_tf.read() >= 48 && timer_tf.read() <= 51){
        wait(3);
        traffic_interrupt('R','R','G',duration);
        traffic_interrupt('R','R','Y',3);
        }else if(timer_tf.read() >= 52 && timer_tf.read() <= 90){
        traffic_interrupt('R','Y','R',3);
        traffic_interrupt('R','R','G',duration);
        traffic_interrupt('R','R','Y',3);
        }else if(timer_tf.read() >= 91 && timer_tf.read() <= 94){
        wait(3);
        traffic_interrupt('R','R','G',duration);
        traffic_interrupt('R','R','Y',3);
        }else if(timer_tf.read() >= 95 && timer_tf.read() <= 169){
        wait(duration);
        }
        led3 = 0;
        timer_tf.start();
        break;
        }
   
   }

//post when changed
int t1red_o,t1yellow_o,t1green_o,t2red_o,t2yellow_o,t2green_o,t3red_o,t3yellow_o,t3green_o = 0;
void change(int t1red_n, int t1yellow_n,int t1green_n, int t2red_n, int t2yellow_n, int t2green_n, int t3red_n, int t3yellow_n, int t3green_n){ 
    
    if(t1red_o != t1red_n || t1yellow_o != t1yellow_n || t1green_o != t1green_n || t2red_o != t2red_n || t2yellow_o != t2yellow_n || t2green_o != t2green_n || t3red_o != t3red_n || t3yellow_o != t3yellow_n || t3green_o != t3green_n){
    http_get();
    t1red_o = t1red_n;   
    t1yellow_o = t1yellow_n;   
    t1green_o = t1green_n;   
    t2red_o = t2red_n;   
    t2yellow_o = t2yellow_n;   
    t2green_o = t2green_n;   
    t3red_o = t3red_n;   
    t3yellow_o = t3yellow_n;   
    t3green_o = t3green_n;   
    }else{}
}

void normal_traffic(){
    change(t1red.read(),t1yellow.read(),t1green.read(),t2red.read(),t2yellow.read(),t2green.read(),t3red.read(),t3yellow.read(),t3green.read());
    if(timer_tf.read() >= 0 && timer_tf.read() <= 47){
    traffic_timer('G','R','R');
    }else if(timer_tf.read() >= 48 && timer_tf.read() <= 51){
    traffic_timer('Y','R','R');
    }else if(timer_tf.read() >= 52 && timer_tf.read() <= 90){
    traffic_timer('R','G','R');
    }else if(timer_tf.read() >= 91 && timer_tf.read() <= 94){
    traffic_timer('R','Y','R');
    }else if(timer_tf.read() >= 95 && timer_tf.read() <= 165){
    traffic_timer('R','R','G');
    }else if(timer_tf.read() >= 166 && timer_tf.read() <= 169){
    traffic_timer('R','R','Y');
    }else if(timer_tf.read() >= 170){
    timer_tf.reset();
    }
}



int main() {
    EthernetInterface eth;  
    HTTPServer svr;
       
    printf("Setting up...\r\n");
    eth.init(); 
    int ethErr = eth.connect();
    if(ethErr < 0)
    {
        printf("Error %d in setup.\r\n", ethErr);
        return -1;
    }
  
      svr.addHandler<HTTPRpcRequestHandler>("/rpc");
        
      //attach server to port 80
      svr.start(80, &eth);
  
      printf("Listening...\n");  
      
    //Listen indefinitely
    Timer tm;
    tm.start();     
    timer_tf.start(); 
      
  while(1)
  {
    normal_traffic();
    svr.poll();
    if(tm.read()>.5)
    {
      tm.start();
    }
  }  
}
