#include "mbed.h"
#include "EthernetInterface.h"

#define ECHO_SERVER_PORT 23

Serial pc(USBTX, USBRX);

int main (void)
{
    pc.baud(115200);

    pc.printf("안녕 세상!\n");
    pc.printf("잠깐만... DHCP 설정중...\r\n");

    uint8_t mac_addr[6] = {0x00, 0x11, 0x22, 0x11, 0xAB, 0xAB};
    //uint8_t mac_addr[6] = {0x00, 0x08, 0xDC, 0x00, 0x01, 0x02};

    EthernetInterface eth;
    eth.init(mac_addr); //Use DHCP
    eth.connect();

    pc.printf("서버주소: %s\r\n", eth.getIPAddress());
    pc.printf("서브넷 마스크: %s\r\n", eth.getNetworkMask());
    pc.printf("게이트웨이: %s\r\n", eth.getGateway());
    pc.printf("맥어드레스: %s\r\n", eth.getMACAddress());

    TCPSocketServer server;
    server.bind(ECHO_SERVER_PORT);
    server.listen();

    while (true) {
        pc.printf("새로운 연결 대기중...\r\n");
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 15000); // Timeout after (1.5)s

        pc.printf("클라이언트 연결됨: %s\r\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if (n <= 0) break;

            // print received message to terminal
            buffer[n] = '\0';
            pc.printf("클라이언트로 부터 받은 메시지:'%s'\r\n",buffer);

            // reverse the message
            char temp;
            for(int f = 0, l = n-1; f<l; f++,l--) {
                temp = buffer[f];
                buffer[f] = buffer[l];
                buffer[l] = temp;
            }

            // print reversed message to terminal
            pc.printf("클라이언트로 메시지 보냄: '%s'\r\n",buffer);

            // Echo received message back to client
            client.send_all(buffer, n);
            if (n <= 0) break;
        }
        client.close();
    }

    pc.printf("Bye Bye.\r\n");
}

