#include "mbed.h"

#include "SNIC_WifiInterface.h"
#include "HTTPClient.h"
#if defined(TARGET_LPC1768)
#include "PowerControl/EthernetPowerControl.h"
#endif

#include "adc.h"        //a+

#define DEMO_AP_SSID                  "nad11-10e168"
#define DEMO_AP_SECURITY_TYPE         e_SEC_WPA2_AES
#define DEMO_AP_SECUTIRY_KEY          "18e36c5e791f9"
#define WAIT 10.0
#define SAMPLE_RATE    150000   // a+

C_SNIC_WifiInterface     wifi( p9, p10, NC, NC, p30 );

#if defined(_DEBUG)
Serial pc(USBTX, USBRX);
#endif

DigitalIn PIR(p8);
//AnalogIn LIGHT(p20);
HTTPClient http;
char str[512];


int HTTPGET(char* sensortype, int value)
{
    //GET data
    printf("\nTrying to fetch page...\n");
    char buf[128];
    sprintf(buf, "http://192.168.179.7/put?type=%s&value=%d",sensortype, value);
    int ret = http.get(buf, str, 128);
    if (!ret)
    {
        printf("Page fetched successfully - read %d characters\n", strlen(str));
        printf("Result: %s\n", str);
    }
    else
    {
    printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    return(0);
}

int main() 
{
#if defined(TARGET_LPC1768)
    PHY_PowerDown();
#endif

    wifi.init(); //Use DHCP

    wait(0.5);
    int s = wifi.disconnect();
    if( s != 0 ) {
        return -1;
    }
    
    wait(0.3);
    
        // Connect AP
    wifi.connect( DEMO_AP_SSID
                , strlen(DEMO_AP_SSID)
                , DEMO_AP_SECURITY_TYPE
                , DEMO_AP_SECUTIRY_KEY
                , strlen(DEMO_AP_SECUTIRY_KEY) );
    wait(0.5);
    wifi.setIPConfig( true );
    wait(0.5);
    printf("IP Address is %s\n", wifi.getIPAddress());
    
    //define var
    int num = 0;
    int value;
    char* sensortype;
    ADC adc(SAMPLE_RATE, 1);
    
    while(1)
    {
        if( num == 0)
        {
            //for PIR sensor
            //GET value from PIR sensor
            sensortype = "PIR";
            value = PIR;
            num = PIR;
            HTTPGET(sensortype, value);
        }

        //for LIGHT
        if(num == 1)
        {
            for(int i=0; i<10; i++)
            {
                //GET value from LIGHT sensor
                sensortype = "LIGHT";
                // a+
                //Set up ADC on pin 20
                adc.setup(p20,1);
                //Measure pin 20
                adc.select(p20);
                //Start ADC conversion
                adc.start();
                //Wait for it to complete
                while(!adc.done(p20));
                value = adc.read(p20);
                printf("Measured value on pin 20 is %04u.\n", value);
                HTTPGET(sensortype, value);
                wait(0.2);
                //GET value from THERMO sensor
                /*
                sensortype = "THERMO";
                value = 
                printf("THERMO value = %d", value);
                HTTPGET(sensortype, value);
                wait(0.2);
                */
            }
            num = 0;
        }
    }

    wifi.disconnect();
    
}
