#include "mbed.h"
//2017/07/07-send

#define Js_X_Margin 0.2
#define Js_Y_Margin 0.2
#define Size_Of_Data 5
#define Plus_F 'A'
#define Minus_F 'X'
double Js_X_Center;
double Js_Y_Center;

int i = 0;
int j;
int xbee_send_data[Size_Of_Data];
double Js_X,Js_Y;
char Speed_X,Speed_Y,Direction_Of_Rotation_X,Direction_Of_Rotation_Y;
//////////////////////////
Serial Xbee(A0,A1);
DigitalOut led(D12);
AnalogIn analog_value_X(A3);
AnalogIn analog_value_Y(A4);
DigitalOut Vcc(A5);
DigitalOut Gnd(A2);
DigitalOut analog_setup_led(D13);
//////////////////////////

void analog_setup()
{
    Vcc=1;
    Gnd=0;
    for(int i=0; i<100; i++) {
        analog_setup_led=!analog_setup_led;
        Js_X_Center+=analog_value_X.read();
        Js_Y_Center+=analog_value_Y.read();
        wait_ms(10);
    }
    Js_X_Center=Js_X_Center/100;
    Js_Y_Center=Js_Y_Center/100;
}

void get_data()
{
    xbee_send_data[Size_Of_Data-1]=false;
    Js_X=analog_value_X.read()-Js_X_Center;
    Js_Y=analog_value_Y.read()-Js_Y_Center;
    if     (Js_X > Js_X_Margin)xbee_send_data[0]=Plus_F; //Direction_Of_Rotation_X
    else if(Js_X <-Js_X_Margin)xbee_send_data[0]=Minus_F;//Direction_Of_Rotation_X
    else                       xbee_send_data[0]=0;      //Direction_Of_Rotation_X
    if     (Js_Y > Js_Y_Margin)xbee_send_data[1]=Plus_F; //Direction_Of_Rotation_Y
    else if(Js_Y <-Js_Y_Margin)xbee_send_data[1]=Minus_F;//Direction_Of_Rotation_Y
    else                       xbee_send_data[1]=0;      //Direction_Of_Rotation_Y
    xbee_send_data[2]=char(abs(Js_X)*255);//Speed_X
    xbee_send_data[3]=char(abs(Js_Y)*255);//Speed_Y
    xbee_send_data[Size_Of_Data-1]=true;
    led=!led;
}
int main()
{
    analog_setup();
    Xbee.baud(9600);
    xbee_send_data[Size_Of_Data-1]=true;
    Xbee.printf("%c",'s');
    while(1) {
        if(xbee_send_data[Size_Of_Data-1]) {
            led=1;
            j=Xbee.getc();
            if(j<Size_Of_Data)Xbee.printf("%c",xbee_send_data[j]);
            if(j==0)get_data();

        }
    }
}