#include "mbed.h"
#include <ADXL345.h>

#define MOSI D11
#define MISO D12
#define SCK D13
#define CS D10

DigitalOut led_1(A2);
DigitalOut led_2(A3);
ADXL345 aMeter(MOSI,MISO,SCK,CS);
Serial pc(USBTX, USBRX,230400);

void aSetup()
{
    //pc.printf("Device ID is: 0x%02x\n", aMeter.getDevId());
    aMeter.setPowerControl(0x00);//スタンバイモードに移行してデバイスを設定します
    aMeter.setDataFormatControl(0x0B);//フル解像度、+/- 16g、4mg / LSB。
    aMeter.setDataRate(ADXL345_3200HZ);// 3.2kHzのデータレート。
    aMeter.setPowerControl(0x08);//測定モード。
}

int main()
{
    aSetup();
    led_1=1;
    int max=0,n=0,xyz[3]= {0,0,0};//読み取りXYZ
    while (1) {
        //wait(0.05);
        aMeter.getOutput(xyz);//xyz取得
        max=0;
        for(int i=0; i<100; i++) {
            n=abs(xyz[2]-240);
            if(n>max)max=n;
            wait(0.001);
        }
        if(max>80) {
            led_1=0;
        }
        if(max>20) {
            led_2=1;
        } else {
            led_2=0;
            led_1=1;
        }
        pc.printf("%i,200\n",(int16_t)xyz[2]-240);//xyz表示
    }
}
