/************************************************************/
/*  (C) 2016 Beijing ARM Accelerator Technology Co., Ltd.   */
/*  Description: Demo for ASC Platform.                     */
/*   Performed an example for getting data form Sensors,    */
/*   then send data to OneNet Cloud by using EDP protocol   */
/*  Author: ss.pan                                          */
/*  Version: 1.01                                           */
/*  Date: 2017-03-28                                        */
/************************************************************/
#include "mbed.h"
#include "wifi_example.h"


//指示灯闪亮
DigitalOut RedLed(PC_13); // 工作指示灯，每秒闪灭一次

//dh11引脚定义
#include "DHT.h"
#define   DHT_DATA_PIN  PB_7
DHT sensor(DHT_DATA_PIN, DHT11);                    //DHT(PinName pin, eType DHTtype)
float h = 0.0f, c = 0.0f;


void DH11_data()
{
    if (!sensor.readData()) 
    {
      c   = sensor.ReadTemperature(CELCIUS);
      h   = sensor.ReadHumidity();  
    }
}

void stm32c8t6_ticker()
{
    RedLed=0;
    DH11_data(); 
    RedLed=1;
}

int main()
{
    connectInit();
    devLink(DEVICEID,APIKEY); 
    while(!checkSocketStatus()) {
            stm32c8t6_ticker(); 
            sendJsonDat("hump ", h);
            sendJsonDat("temp", c); 
            }        
        
}
