#include "mbed.h"
#include <time.h>
#include "CriusOLED.h"
#include "HCSR04.h"
#include "AutomationElements.h"
#include "DS1302.h"
#include  "AM2320.h"

//全局变量
DigitalOut led(LED1);
DigitalOut RST(D6);
char buffer1[20],buffer2[50],buffer3[20];
time_t rawtime;
struct tm timeinfo;
//Comment this line if the DS1302 is already running
//#define INITIAL_RUN
#define SCLK     A0
#define IO      A1
#define CE      A3
DS1302 clk(SCLK, IO, CE);

//AM2320初始化
AM2320 am2320(i2c);
int h;
int t;
//BME280初始化
#include "BME280.h"
BME280 bme280(I2C_SDA, I2C_SCL);

Serial pc(SERIAL_TX, SERIAL_RX,921600);

HCSR04 sensor(D2, D3);
float sampleTime = 0.5;
PT1 filter(1, 2, sampleTime);
Ticker ticker;
float Distance;
float filtereddistance; 

void calc() {
    sensor.startMeasurement();
}

#include "ESP8266.h"
//esp8266
ESP8266 wifi(A7, A2, 921600); // baud rate for wifi
char snd[300],rcv[500];
#define IP "184.106.153.149" // thingspeak.com IP Address
#define IP1 "link.tlink.io" // tlink.io IP Address
#define IP2 "tcp.lewei50.com" //tcp.lewei50.com IP Address
#define IP3 "api.heclouds.com"   //http onenet IP Address
uint8_t esp8266_time;
AnalogIn inputPin(A6); // temp

void esp82666()
{
   switch(esp8266_time)
   {
    case 0:RST=0;wait(0.001);RST=1;break;
    case 7:  strcpy(snd,"AT+CIPMODE=0");wifi.SendCMD(snd);break;//Setting WiFi into MultiChannel mode
    case 8:  strcpy(snd,"AT+CIPMUX=1");wifi.SendCMD(snd);break;//Setting WiFi into MultiChannel mode
    }
   switch(esp8266_time%40)
   {
    case 9:  sprintf(snd,"AT+CIPSTART=1,\"TCP\",\"%s\",80",IP3);wifi.SendCMD(snd);break;//Initiate connection with onenet server 
    case 10: strcpy(snd,"AT+CIPSEND=1,200");wifi.SendCMD(snd);wait(0.001);
             sprintf(snd,"POST /devices/4605176/datapoints?type=3 HTTP/1.1\r\n"
                         "api-key: bryNFvy6sbj9Isu5mHXp3fwIvtc=\r\n"
                         "Host:api.heclouds.com\r\n"
                         "Connection:close\r\n"
                         "Content-Length:49\r\n"
                         "\r\n"
                         "{\"juli\":%03.2f,\"time\":%010d,\"mq135\":%02.2f}\r\n",
                         Distance,rawtime,inputPin.read()*100);wifi.SendCMD(snd);break;
    case 11: sprintf(snd,"AT+CIPSTART=2,\"TCP\",\"%s\",9960",IP2);wifi.SendCMD(snd);break;//Initiate connection with tcp.lewei50.com server   
    case 12: strcpy(snd,"AT+CIPSEND=2,87");wifi.SendCMD(snd);wait(0.001);//Send Number of open connections,Characters to send 
             strcpy(snd,"{\"method\": \"update\",\"gatewayNo\": \"01\",\"userkey\": \"e84c3784af864fb0bb70fd33cb434a45\"}&^!");wifi.SendCMD(snd);break;//Post values to cp.lewei50.com
    case 13: strcpy(snd,"AT+CIPSEND=2,104");wifi.SendCMD(snd);wait(0.001);//Send Number of open connections,Characters to send 
             sprintf(snd,"{\"method\": \"upload\",\"data\":[{\"Name\":\"shidu\",\"Value\":\"%2.4f\"},{\"Name\":\"wendu\",\"Value\":\"%010d\"}]}&^!",inputPin.read(),rawtime);wifi.SendCMD(snd);break;//Post values to tcp.lewei50.com 
    case 14: sprintf(snd,"AT+CIPSTART=4,\"TCP\",\"%s\",80",IP);wifi.SendCMD(snd);break;//Initiate connection with THINGSPEAK server 
    case 15: strcpy(snd,"AT+CIPSEND=4,46");wifi.SendCMD(snd);wait(0.001);//Send Number of open connections,Characters to send 
             sprintf(snd,"GET /update?key=YPEAG0PP1LZ9ZUY5&field2=%2.2f\r\n",inputPin.read());wifi.SendCMD(snd);break;//Post values to thingspeak
    case 16: sprintf(snd,"AT+CIPSTART=3,\"TCP\",\"%s\",8647",IP1);wifi.SendCMD(snd);break;//Initiate connection with THINGSPEAK server 
    case 17: strcpy(snd,"AT+CIPSEND=3,16");wifi.SendCMD(snd);wait(0.001);//Send Number of open connections,Characters to send 
             strcpy(snd,"3L0P2M2S3P9061I6");wifi.SendCMD(snd);clear_display();break;//Send Number of open connections,Characters to send 
   } 
    if(esp8266_time%40>=18)
    {
     strcpy(snd,"AT+CIPSEND=3,30");wifi.SendCMD(snd);wait(0.001);
     sprintf(snd,"DTU%2.4f,%010d,%04.4f",inputPin.read(),rawtime,Distance);wifi.SendCMD(snd);   
    }
   ++esp8266_time;
}

int main()
{
    //IIC初始化
    i2c.frequency(400000);
    
    //初始化OLED12864
    init_OLED();
    displayOn();
    reset_display();
    
    // Initialize HCSR04
    sensor.setRanges(2, 500);
    ticker.attach(&calc, sampleTime);
    
    //如果程序需要，可以手动设定ds1302的时间 
    #ifdef INITIAL_RUN
    timeinfo.tm_year = 2017-1900;
    timeinfo.tm_mon = 1-1;
    timeinfo.tm_mday = 7;
    timeinfo.tm_hour=15;
    timeinfo.tm_min=45;
    timeinfo.tm_sec=0;
    timeinfo.tm_wday=6-1;
    clk.set_time(mktime(&timeinfo));
    #endif
    //时间设定，将ds1302时间写入MCU中，程序时间读取通过MCU嘀嗒时钟   
    rawtime = clk.time(NULL);
    set_time(rawtime);  
    
    pc.printf("STM32L432 Initializing OK\r\n");
    RST=1;
    while(1) {
        //测量距离
        while(!sensor.isNewDataReady()) {
        }
        //led闪亮表示程序运行
        led=!led;
        
        //测量并显示距离
        Distance = sensor.getDistance_cm();
        filter.in(Distance);
        filtereddistance = filter.out();
        snprintf(buffer1, 20, "%3.1fcm %3.1fcm   ",Distance, filtereddistance);    
        sendStrXY(buffer1,2,0);         // pc.printf(buffer1);          
        
        //显示MCU读取时间
        rawtime = time(NULL);
        snprintf(buffer2, 50, "%s %10d %4.2f%%",ctime(&rawtime),rawtime,inputPin.read()*100); 
        sendStrXY(buffer2,3,0);
        
        //AM2320读取数据
        h = am2320.humidity();
        t = am2320.temperature();
        snprintf(buffer3, 20, "%3d.%dc %3d.%d%%",t/10,t%10,h/10,h%10); 
        sendStrXY(buffer3,6,0);
        
        //bme280读取数据
        snprintf(buffer1,sizeof(buffer1), "%2.2fC %6.0fPa",bme280.getTemperature(), bme280.getPressure()*100); 
        sendStrXY(buffer1,7,0); 
        
        //ESP8266执行操作
        esp82666();        
    }
}
