#include "mbed.h"
#include "DS1302.h"
#include "SDFileSystem.h"

Serial pc(P0_4,P0_0,921600);
Ticker ticker; 
float sampleTime = 1.0;
// Defines for the DS1302 timer module
//#define INITIAL_RUN 1
#define LED1    P0_15
#define LED2    P0_16
#define LED3    P0_17
#define SCLK    P0_20
#define IO      P0_21
#define CE      P0_22

SDFileSystem sd(P0_26, P0_25, P0_24, P0_15, "sd"); //MOSI, MISO, SCLK, SSEL. (SD Card) Tested on K64F, correct pins.
DS1302 clk(SCLK, IO, CE); // ports for the DS1302 time keeper
AnalogIn PH0(P0_6);  //PH传感器 A0
AnalogIn AD1(P0_14);  //AD采集信号 A1
float ad1= 0.00;
float ph0= 0.00;
char sd_flag;
DigitalOut RedLed(LED1); // 工作指示灯，每秒闪灭一次
DigitalOut GreenLed(LED2); // SD卡读取状态寄存器
DigitalOut Blueled(LED3); // DHT11 read indication

void LPC824_ticker()
{
    RedLed=!RedLed;
    ph0 = PH0.read() * 3300; 
    ad1 = AD1.read() * 3300; 
    time_t seconds = clk.time(NULL);
    pc.printf("PH0:%.0f mVd,AD1:%.0f mV,%s\r\n",ph0,ad1,ctime(&seconds));
    
    if(sd_flag)
    {
        GreenLed= 0;
        FILE *fp = fopen("/sd/LPC824date/data001.csv", "a");
        if(fp != NULL) 
        {
            fprintf(fp, "%s\t%.0f\t%.0f\n", ctime(&seconds), ph0,ad1); 
            fclose(fp); 
            GreenLed= 0;  
        }
        else 
        {
             GreenLed= 1;            
        }        
    }    
}

void sd_init()
{
    RedLed=1;
    mkdir("/sd/LPC824date", 0777);
    FILE *fp = fopen("/sd/LPC824date/data001.csv", "w");
    if(fp == NULL) {
        pc.printf("Could not open file for write, Please insert your SD CARD!\n");
        GreenLed= 1;
        sd_flag=0;
        }
     else 
     {
         sd_flag = 1;
         GreenLed= 0;
     }      
}

int main() {   
    pc.printf("LPC824 sd-dh11-ph-ds1302 demo start\r\n");
    #ifdef INITIAL_RUN    
    clk.set_time(1494675200); //2017.5.13.11.33
    #endif
    char storedByte = clk.recallByte(0);
    clk.storeByte(0, storedByte + 1); 
    sd_init(); 
    ticker.attach(&LPC824_ticker, sampleTime);   
    while(1)
    {
        
    }
}
