#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"

//EthernetNetIf eth; 
HTTPClient http;
DigitalOut led1(LED1);
DigitalOut led2(LED4);
  
int main() {

  printf("Setting up...\n");

  EthernetNetIf eth(
  IpAddr(10,0,0,20), //IP Address
  IpAddr(255,0,0,0), //Network Mask
  IpAddr(10,0,0,1), //Gateway
  IpAddr(10,0,0,1)  //DNS
   );


  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");
  
  HTTPText txt;
  
  HTTPResult r = http.get("http://10.0.0.1/", &txt);
  if(r==HTTP_OK)
  {
    printf("GET Result :\"%s\"\n", txt.gets()); 
    led1=1;
    led2=1;
  }
  else
  {
    printf("Error %d\n", r);
    led1=0;
    led2=1;
  }
  
  while(1)
  {
    //printf("ciao");
  }
  
  return 0;
  
}
