// This example program will first delete any stored messages held in the radio.
// Then it will send an SMS message before looping while reading received SMS
// message. 
//
// ** Configure the apn[] value below for MTQ-H5 or MTQ-LAT3 radios.
// ** Configure txtmsg.phone_number below for SMS destination.

#include "mbed.h"
#include "MTSCellularInterface.h"
#include "MTSLog.h"
#include "example_config.h"
#include <stdio.h>
#include <string>
#include <iostream>
#include <sstream>
#include "picojson.h"

//using json = nlohmann::json;

#if ACTIVE_EXAMPLE == SMS_EXAMPLE

// Dragonfly debug port. 
Serial debug_port(USBTX, USBRX);
AnalogIn   ain(A0);

int main(){
    while(true){   
        float per = ain * 3.7f * 100.0f;
        printf("percentage: %1.0f%%\n", ain.read() * 7.4f * 100.0f);
    wait(5);
    }
    
    //Sets the log level to INFO, higher log levels produce more log output.
    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG and TRACE.
    //For the Dragonfly, installed on the UDK 2.0 board, messages are output on the
    // UDK 2.0 USB port “COMxx: STMicroelectronics STLink Virtual COM port (xx)”
    // at 9600bps.    
    mts::MTSLog::setLogLevel(mts::MTSLog::INFO_LEVEL);
    //Sets the debug port to 115200bps.
    debug_port.baud(9600);

    // Create an MTSCellularInterface object. Serial pins for the Dragonfly board that connect
    // to the on board cellular radio:
    // RADIO_TX = pin PC_7, RADIO_RX = pin PC_6
    MTSCellularInterface *radio = new MTSCellularInterface(RADIO_TX, RADIO_RX);
    
    // Print the MTSCellularInterface version
    logInfo("MTSCellularInterface Version %s", radio->get_library_version().c_str());

    //Modify to match your apn if you are using an HSPA radio with a SIM card.
    const char apn[] = "rogers-core-appl1.apn";
    
    // Check if device is powered
    //while(true){
        if(radio->is_powered()){
            logInfo("Device is powered");
        }
        else{
            logInfo("Device is not powered");
        }
        //wait(10);
    //}
    
    //Set radio apn
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to set apn\n");
        }
        else if (radio->set_credentials(apn) == NSAPI_ERROR_OK) {
            logInfo("Successfully set apn\n");
            break;
        } else {
            logInfo("Failed to set apn\n");
            wait(1);
        }
    }
    
    // Enable GPS
    radio->gps_enable();
    
    // Get GPS position
    while(true){
        MTSCellularRadio::gpsData gps_data = radio->gps_get_position();        
        bool gps_success = gps_data.success;
        string latitude = gps_data.latitude;
        string longitude = gps_data.longitude;
        float hdop = gps_data.hdop;
        float altitude = gps_data.altitude;
        float fix = gps_data.fix;
        string cog = gps_data.cog;
        float kmhr = gps_data.kmhr;
        float knots = gps_data.knots;
        string timestamp = gps_data.timestamp;
        
        stringstream ss;
        ss << gps_data.satellites;
        string satellites = ss.str();
                
        if(gps_success == true){
            picojson::object json_msg;
            picojson::object gps_attributes;
            
            string JF_ID = "12345";
            string event_ID = "1";
 
            json_msg["JF_ID"] = picojson::value(JF_ID);
            json_msg["event_ID"] = picojson::value(event_ID);
            
            gps_attributes["latitude"] = picojson::value(latitude);
            gps_attributes["longitude"] = picojson::value(longitude);
            gps_attributes["hdop"] = picojson::value(hdop);
            gps_attributes["altitude"] = picojson::value(altitude);
            gps_attributes["fix"] = picojson::value(fix);
            gps_attributes["cog"] = picojson::value(cog);
            gps_attributes["kmhr"] = picojson::value(kmhr);
            gps_attributes["knots"] = picojson::value(knots);
            gps_attributes["satellites"] = picojson::value(satellites);
            gps_attributes["timestamp"] = picojson::value(timestamp);
            
            json_msg["gps_attributes"] = picojson::value(gps_attributes);
                        
            string GPSJSONString = picojson::value(json_msg).serialize();
                
            logInfo("The current JSON value is %s", GPSJSONString);
        }
        else{
            logInfo("GPS Location failed");
        }  
        wait(10);
    }
/*    
    //Phone number to send to and receive from. Must be in the form "1xxxxxxxxxx"
    MTSCellularRadio::Sms txtmsg;
    txtmsg.phone_number = "12045588580";
    txtmsg.message = "Hello World! MTSCellularInterface is up and running!";    
    
    //Delete any previously received SMS messages
    for (int i = 0; i < 10; i++) {
        if (i >= 10) {
            logError("Failed to delete SMS messages\n");
        }
        else if (radio->delete_all_received_sms() == NSAPI_ERROR_OK) {
            logInfo("Deleted all SMS messages\n");
            break;
        } else {
            wait(1);
        }
    }

    // Send SMS message to phone
    for (int i = 1; i < 10; i++) {
        if(radio->send_sms(txtmsg) == NSAPI_ERROR_OK) {
            logInfo("Sent SMS successfully:<%s>\n", txtmsg.message.c_str());
            break;
        } else {
            logError("Failed to send SMS<%s>\n", txtmsg.message.c_str());
        }
    }
    
    //Checking for received SMS messages
    while (true) {
        logInfo("Checking for received messages");
        vector<MTSCellularRadio::Sms> recv = radio->get_received_sms();
        if(recv.size() > 0) {
            int size = recv.size();
            for (int i = 0; i < size; i++) {
                logInfo("Message %d: [%s] [%s] [%s]", i, recv[i].phone_number.c_str(), recv[i].timestamp.c_str(), recv[i].message.c_str());
            }
        }
        
        if(radio->delete_only_read_sms() != NSAPI_ERROR_OK) {
            logError("Failed to delete received and read SMS messages");
        }
        wait(10);
    }
*/    
    return 0;

}

#endif
