#include "mbed.h"


#define EOL '\r'
#define COMMAND_SIZE 32

#define EQ(a,b) (!strcmp(a,b))

#define MAX_POWER 70.0

DigitalOut laser(LED1);

Serial port(USBTX, USBRX);

char buffer[COMMAND_SIZE];
int pos = 0;


int state_prompt = 1;
int state_delay = 0;
int state_laser = 0;
int state_external = 0;
char state_power[16];


/* return 1 if line complete, 0 - otherwise */
int read_line() {
    unsigned char ch;

    while (port.readable()) {
        if ( (ch = port.getc()) == EOL) {
            buffer[pos] = 0;
            pos = 0;
            return 1;
        } else {
            buffer[pos++] = ch;
        }
    }

    return 0;
}

void write_line(char *message) {
    port.printf("%s\r\n", message);
}

void runCommand(char *command) {
    if ( EQ(command, ">=0") ) {
        state_prompt = 0;
    } else if ( EQ(command, "CDRH=0") ) {
        state_delay = 0;
    } else if ( EQ(command, "CDRH=1") ) {
        state_delay = 1;
    } else if ( EQ(command, "L=0") ) {
        state_laser = 0;
        laser = 0;
    } else if ( EQ(command, "L=1") ) {
        state_laser = 1;
        if (state_delay) {
            wait(5);
        }
        laser = 1;
    } else if ( EQ(command, "EXT=0") ) {
        state_external = 0;
    } else if ( EQ(command, "EXT=1") ) {
        state_external = 1;
    } else if ( EQ(command, "?MAXLP") ) {
        port.printf("MAXLP=%.2f%c", MAX_POWER, EOL);
        return;
    } else if ( ! strncmp(command, "P=", 2)) {
        strcpy(state_power, &command[2]);
    } else if ( EQ(command, "?P")) {
        port.printf("P=%s%c", state_power, EOL);
        return;
    } else {
        return;
    }

    write_line(command);
}

void setup() {
    port.baud(19200);
    port.format(8, Serial::None, 1);
    
    strcpy(state_power, "");
}

int main() {

    pos = 0;

    setup();

    while (1) {
        if (read_line()) {
            runCommand(buffer);
        }
    }

    return 0;
}
