#ifndef PLAYER_EMBEDDED_H
#define PLAYER_EMBEDDED_H

#include "stdint.h"

#include "PlayerBase.h"
#include "RingBuffer.h"

// #include <iostream>

namespace olc {

class PlayerEmbedded : public PlayerBase
{
public:
    PlayerEmbedded(fou::RingBuffer8k &aBuffer) : mBuffer(aBuffer) {};

    // void setGalvo(uint16_t x, uint16_t y);
    // void setLaserPower(uint16_t power);  
    // void wait(uint16_t ms);
  
protected:  
  inline int bytesLeft() {
// std::cout << "buffer size" << mBuffer.size() << std::endl; 
    return mBuffer.size(); 
  };
  inline uint8_t get() { 
    uint8_t d = mBuffer.front(); 
    mBuffer.popFront();
    return d; 
  };  
  
  fou::RingBuffer8k& mBuffer;
};


}; // end namespace ol

#endif // PLAYER_BASE_H
