#ifndef OLC_VECTOR_H
#define OLC_VECTOR_H

#include "stdint.h"

namespace olc {
  
#define OLC_DEVICE_RECEIVING_PORT 3000
#define OLC_DEVICE_SENDING_PORT 3001  
  
  /**
   *   the protocol so far.
   *
   *   it is packet based. packets should not be longer than 1024 bytes due to hardware
   *   restrictions. We assume udp should be error free enough being the only device on the
   *   cable.
   
   *   MOVE_TO  move mirrors to position x,y
   *   LINE_TO  move mirrors to position x,y and laser on
   *   these commands are 5 bytes long  (uint8 opcode, uint16 x, uint16 y)
   
   *   H_MOVE_TO move mirror horizontaly to position x
   *   use imagination for V_MOVE_TO, H_LINE_TO, V_LINE_TO
   *   these commands are 3 bytes long (uint8 opcode, uint16 l)
   
   *   LASER_POWER sets the laser intensity (uint8 opcode, uint16 power)
   *   we can extend if we need color.
   
   *   (not implemented) FAST_MODE (uint8) Sets the laser in fast mode.
   in fast mode, the motion commands will be set, and the galvo goes to the new position
   as fast as possible.
   // i guess we should have a precise timing parameters.
   
   ----- slow speed ------
   *   (not implemented) SLOW_MODE (uint8 opcode) (default) Sets the laser in slow mode.
   in slow mode means that we go step for step over each pixel with a line raster algorithm.
   
   
   *   STEP_SIZE (uint8 opcode, uint16 size) sets the galvo step size when drawing lines.
   using cheap optics and a short throw the laser spot size is probably a few orders of
   maginitude larger than the theoretical step size of the galvo. This parameter allows
   you to control the step size when going slow.
   
   *   STEP_DELAY (uint8 opcode, uint16 delay) sets an optional delay when drawing each pixels.
   this is sometimes neccesairy for extra illumination of the surface.
   */
  
  // bit 7 (128) means pen_down
  // 
  // laser_power r,g,b
  
  
  enum PathCommands {
    E_STOP = 0,         // 1 uint8 opcode
    PEN_DOWN = 128,     // 1 uint8 opcode

    
    MOVE_TO   = 1,     // 5 uint8 opcode, uint16 x, uint16 y
    H_MOVE_TO = 2,     // 3 uint8 opcode, uint16 x
    V_MOVE_TO = 3,     // 3 uint8 opcode, uint16 y
    
    STEP_SIZE   = 10,   // 3 uint8 opcode, uint16 step_size
    STEP_DELAY  = 11,    // 3 uint8 opcode, uint16 step_delay

    PEN_UP = 15,     // 1 uint8 opcode
    READY = 16,      // 1 uint8 opcode
    
    CALIBRATION_SCAN = 17, // 1 uint8 opcode uint16 top_x, uint16 left_y, uint16 bottom_x, uint16 right_y
    POINT = 18, // 1 unit8 opcode uint16 x, uint16 y
    
    READ_COLOR = 19, // 1 uint8 opcode uint8
    
    MESSAGE = 20, // 3+x uint8 opcode, level, length of message, x bytes
    BUFFER_LEFT_REPORT = 21, // opcode, uint16_t
    WAIT = 22, // opcode, uint16t time
    AYT = 23, // are you there
        
    REPORT_COLOR = 25, // 1 + 3 x uint8    

        
    REPORT_BUFFER_IN_SIZE = 26,   // 1 + uint16 size
    BUFFER_IN_SIZE = 27,         // 1 

    ACK = 30,
    NACK = 31,
        
    LINE_TO   = PEN_DOWN + MOVE_TO,   // 5 uint8 opcode, uint16 x, uint16 y
    H_LINE_TO = PEN_DOWN + H_MOVE_TO, // 3 uint8 opcode, uint16 x
    V_LINE_TO = PEN_DOWN + H_MOVE_TO, // 3 uint8 opcode, uint16 y
    
    LASER_POWER = 100,        // 3 uint8 opcode, uint16 power
    LASER_POWER_RGB = 101,    // 4 uint8 opcode, 3x uint8 power r,g,b
    
    // writing bitmaps. horizontally. based on step_size.   
    BITMAPU8 = 150,     // variable uint8 opcode, uint8 size, max 256 uint8 power
    //  BITMAP16_RGB = 151, // 49 uint8 opcode, 16 x 3 x uint8 power r,g,b
    
    NOTHING = 255
  };
  
}; // end namespace

#endif
