#ifndef PLAYER_BASE_H
#define PLAYER_BASE_H

#include "stdint.h"

namespace olc {
  
  class PlayerBase
  {
  public:
    PlayerBase();
    virtual void setGalvo(uint16_t x, uint16_t y);
    virtual void setLaserPower(uint16_t power);  
    virtual void wait(uint16_t ms);
    virtual void reportBufferInSize() {};

    // this is for scanning to calibrate camera.
    virtual void calibrationScan() {};
    virtual void point(uint16_t x, uint16_t y) {};

    // this is for color scanning
    virtual void readColor() {};
    virtual void setLaserPowerRgb(uint8_t red, uint8_t green, uint8_t blue) {};

    virtual void ready() {};
    virtual void areYouThere() {};
    virtual void message(int aLevel, int aLength, char *aString) {};

    
    inline void penDown() {
      mPenDown = true;
      setLaserPower(mLaserPower);
    }
    inline void penUp() {
      mPenDown = false;
      setLaserPower(0);
    }
    
    void setData(uint8_t *data, int size);
    void setStepSize(uint16_t s) { mStepSize = s; };
    uint16_t getStepSize() { return mStepSize; };
    void setDelay(uint16_t ms) { mDelay = ms; };
    void reset();
    bool hasNext();
    bool playOne();
    
    uint16_t getX() { return mGalvoX; };
    uint16_t getY() { return mGalvoY; };
    
  protected:  
    void rasterLine(uint16_t x0, uint16_t y0, uint16_t x1, uint16_t y1, int step=1);
    
    
    inline virtual int bytesLeft() {
      return mSize - mPlayHead;
    }
    inline virtual uint8_t get() {
      mPlayHead++;    
      return mData[mPlayHead-1];
    }
    
    // TODO(dps): take care of endian
    inline uint16_t decodeU16() {
      uint16_t i;
      i =  (uint16_t)get() << 8;
      i |= (uint16_t)get();
      return i;    
    }
    
    
    uint8_t *mData;
    int mSize;
    int mPlayHead;
    
    bool mPenDown;
    uint16_t mLaserPower;
    uint16_t mGalvoX;
    uint16_t mGalvoY;
    uint16_t mDelay;
    uint16_t mStepSize;
  };
  
  
}; // end namespace ol

#endif // PLAYER_BASE_H
