#ifndef WRITER_EMBEDDED_H
#define WRITER_EMBEDDED_H

#include "stdint.h"
#include "WriterBase.h"
#include "RingBuffer.h"

namespace olc {
  
/**
 *   write ol commands to a bytestring. 
 **/

template <class T>
class WriterEmbedded : public WriterBase {

public:
  WriterEmbedded(T& aBuffer) : mBuffer(aBuffer) {
  };
  inline int size() 
  { 
    return mBuffer.size(); 
  };
  inline int spaceLeft()
  {
    return mBuffer.capacityLeft();
  };

  
  protected:
  T& mBuffer;
  void put(uint8_t aValue) { 
    mBuffer.pushBack(aValue);  
  };  
};

} // end namespace ol

#endif // WRITER_BASE_H
