#ifndef WRITER_BASE_H
#define WRITER_BASE_H

#include "stdint.h"

namespace olc {
  
/**
 *   write ol commands to a bytestring. 
 **/

class WriterBase {
  public:
    WriterBase();
    
    bool penUp();
    bool penDown();
    bool wait(uint16_t aWait);

    
    bool moveTo(uint16_t aX, uint16_t aY );
    bool lineTo(uint16_t aX, uint16_t aY );
    bool setLaserPower(uint16_t aPower );
    bool setStepSize(uint16_t aStepSize );
    bool bitmapU8(uint8_t *aData, uint8_t aSize);
    bool areYouThere();
    bool ready();
    bool message(int aLevel, const char *aString);
  
    bool reportBufferInSize();
    bool bufferInSize(uint16_t aSize);
  
    bool readColor();
    bool reportColor(uint8_t c);
  
    void setData(uint8_t *aData, int aCapacity);

  
  // overload this for different buffer type.
  virtual int size() {
    return mPlayHead;
  }
  virtual int spaceLeft() {
    return mCapacity - mPlayHead;
  }
  
  protected:
  
  // overload this for different buffer type.
  virtual void put(uint8_t aData) {
    mData[mPlayHead] = aData;
    mPlayHead++;
  }
  
  void encodeU16(uint16_t u) {
    put( (uint8_t)(u >> 8) );
    put( (uint8_t)(u & 0xFF) );
  }
  
  uint8_t *mData;
  int mPlayHead;
  int mCapacity;
    
  bool mPenDown;
  uint16_t mLaserPower;
  uint16_t mGalvoX;
  uint16_t mGalvoY;
};
  
  
} // end namespace ol

#endif // WRITER_BASE_H
