#include "WriterBase.h"

#include "assert.h"
#include "VectorFormat.h"

// for strlen
#include "string.h"

olc::WriterBase::WriterBase() :
  mData(0),
  mPlayHead(0),
  mCapacity(0),
  mPenDown(0),
  mLaserPower(0),
  mGalvoX(0),
  mGalvoY(0)
{
}


bool olc::WriterBase::penUp()
{
  if (spaceLeft() < 1) return false;
  put((uint8_t)olc::PEN_UP );  
  return true;
}

bool olc::WriterBase::penDown()
{
  if (spaceLeft() < 1) return false;
  put((uint8_t)olc::PEN_DOWN ); 
  return true;
}

bool olc::WriterBase::wait(uint16_t aWait)
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::WAIT );
  encodeU16( aWait );
  return true; 
}


bool olc::WriterBase::moveTo(uint16_t aX, uint16_t aY) {
  if (spaceLeft() < 5) return false;
  put( (uint8_t)olc::MOVE_TO );
  encodeU16( aX );
  encodeU16( aY );
  return true;
}

bool olc::WriterBase::lineTo(uint16_t x, uint16_t y) 
{
  if (spaceLeft() < 5) return false;
  put((uint8_t)olc::LINE_TO );
  encodeU16( x );
  encodeU16( y );
  return true;
}

bool olc::WriterBase::setLaserPower(uint16_t aPower) 
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::LASER_POWER );
  encodeU16( aPower );
  return true; 
}

bool olc::WriterBase::setStepSize(uint16_t aStepSize) 
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::STEP_SIZE );
  encodeU16( aStepSize );
  return true; 
}

bool olc::WriterBase::readColor()
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::READ_COLOR );
  return true;  
}

bool olc::WriterBase::reportColor(uint8_t c)
{
  if (spaceLeft() < 4) return false;
  put( (uint8_t)olc::REPORT_COLOR );
  put( c );
  return true;
}

bool olc::WriterBase::reportBufferInSize()
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::REPORT_BUFFER_IN_SIZE );
  return true;  
}

bool olc::WriterBase::bufferInSize(uint16_t aSize) 
{
  if (spaceLeft() < 3) return false;
  put( (uint8_t)olc::BUFFER_IN_SIZE );
  encodeU16( aSize );
  return true;
}

bool olc::WriterBase::bitmapU8(uint8_t *aData, uint8_t aSize) 
{
  if (spaceLeft() < 2) return false;
  put( (uint8_t)olc::BITMAPU8 );
  put( aSize );
  for(int i=0; i < (int)aSize; i++) {
    put( aData[i] );
  }
  return true; 
}

bool olc::WriterBase::message(int aLevel, const char *aString) {  
  // first calculate size
  size_t size = strlen(aString);
  if (size > 254 ) return false;
  if (spaceLeft() < 4+size) return false;

  put( (uint8_t)olc::MESSAGE );
  put( (uint8_t)aLevel );
  put( (uint8_t)size );
  const char* ptr = &(aString[0]);
  while (*ptr != '\0') {
    put( *ptr );
    ptr++;
  }
  put ( 0 ); // end message with a zero.
  return true;
}

bool olc::WriterBase::areYouThere() {
  if (spaceLeft() < 1) return false;
  put( (uint8_t)olc::AYT );
  return true;
}

bool olc::WriterBase::ready() {
  if (spaceLeft() < 1) return false;
  put( (uint8_t)olc::READY );
  return true;
}


void olc::WriterBase::setData(uint8_t *aData, int aCapacity) {
  assert(aCapacity > 0);
  assert(aData != 0);
  mPlayHead = 0;
  mCapacity = aCapacity;
  mData = aData;
}



