#include "mbed.h"
#include "dispBoB.h"

dispBoB db(p28, p27, p26);          //instantiate a dispBoB object
InterruptIn trigger(p12);           //set up the trigger as an external interrupt
Timer t;

void up(){                          //call this on rising edge
    t.start();                      //start timer
}

void down(){                        //call this upon falling edge
    t.stop();                       //stop timer
    db.locate(0);
    db.printf("%06d", t.read_ms()); //print counter info to dispBoB 
    t.reset();                      //reset timer
}

int main() {
    trigger.mode(PullUp);           //activate internal pull up (hardware specific)
    db.init();                      //ALWAYS initialise dispBoB
    db.cls();                      
    trigger.rise(&up);              //attach up() to interrupt on rising edge of trigger
    trigger.fall(&down);            //attach down() to interrupt on falling edge of trigger
    db.printf("%06d", t.read_ms()); //display an initial count "000000"
    
    //To change the timebase just replace the read_ms() function with
    //read() for seconds and read_us() for microseconds. These use a 32bit 
    //int microsecond counter, so have a max time of ~30mins
}
