#include "mbed.h"
#include "dispBoB.h"
#include "stdio.h"

dispBoB db(p28, p27, p26);                  //object instantiation
extern "C" int mbed_mac_address(char *);

int main() {
    uint64_t uid = 0;
    char mac[6];
    mbed_mac_address(mac);                  //this copies the MAC address into the 
    uid = mac[0] << 40 | mac[1] << 32 |     //variable 'uid'
          mac[2] << 24 | mac[3] << 16 |
          mac[4] << 8  | mac[5] << 0;   
    char MACAddressBuffer[9];
    sprintf(MACAddressBuffer, "%x", uid);   //convert type uint64_t --> char* (format hex)
    db.scroll(MACAddressBuffer, 0.2);       //scroll foramtted MAC address across dispBoB
}