#include "mbed.h"
#include "dispBoB.h"

dispBoB db(p28, p27, p26);          //instantiate a dispBoB object
InterruptIn trigger(p12);           //set up the trigger as an external interrupt
Timer t;

bool b = false;

void trig(){                        //function to call upon interrupt
    db.locate(0);
    db.printf("%06d", t.read_ms()); //print current time reading 
    if(b == false){
        t.start();                  //start timer
        b = true;
    } else {
        t.stop();                   //stop timer
        db.printf("06d", t.read_ms());  //print out stopwatch time in milliseconds
        t.reset();                  //reset and restart timer
        t.start();
    }
}

int main() {
    trigger.mode(PullUp);           //activate internal pull up (hardware specific)
    db.init();                      //ALWAYS initialise the dispBoB 
    db.cls();                       
    trigger.rise(&trig);            //attach trig() to interrupt on rising edge of trigger

    db.printf("%06d", t.read_ms()); //print initial time reading (000000)
    
    //To change the timebase just replace the read_ms() function with
    //read() for seconds and read_us() for microseconds. These use a 32bit 
    //int microsecond counter, so have a max time of ~30mins
}
