//NXP PCA9635 library
//mbed Team     -   28th June 2011
//Daniel Worrall

#include "mbed.h"
#include "PCA9635.h"
#include "dispBoB.h"


    static const char loc[] = {0x02, 0x02, 0x04, 0x04, 0x10, 0x10, 0x12, 0x12}; 
    static const short dispL[] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x1008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0002, 0xC006, 0x600C, 0x0000, 0x0000, 0x0000, 0x0001, 0x1000, 0x0000,
    0xE00E, 0x2008, 0xC00D, 0x600D, 0x200B, 0x6007, 0xE007, 0x200E, 0xE00F, 0x600F, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    
    0x0000, 0xE00D, 0xE003, 0xC001, 0xE009, 0xC007, 0x8007, 0x600F, 0xA003, 0x8000, 0x6008, 0xA007, 0xC002, 0xA005, 0xA001, 0xE001,
    0x800F, 0x200F, 0x8001, 0x6007, 0xC003, 0xE000, 0xE000, 0xE004, 0xA00B, 0x600B, 0xC00D, 0xC006, 0x0000, 0x600C, 0x0000, 0x4000,
    0x1000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xC006, 0x0000, 0x600C, 0x0000, 0x0000
    };
    static const short dispR[] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0180, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0020, 0x0C60, 0x06C0, 0x0000, 0x0000, 0x0000, 0x0010, 0x0100, 0x0000,
    0x0EE0, 0x0280, 0x0CD0, 0x06D0, 0x02B0, 0x0670, 0x0E70, 0x02E0, 0x0EF0, 0x06F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    
    0x0000, 0x0ED0, 0x0E30, 0x0C10, 0x0E90, 0x0C70, 0x0870, 0x06F0, 0x0A30, 0x0800, 0x0680, 0x0A70, 0x0C20, 0x0A50, 0x0A10, 0x0E10,
    0x08F0, 0x02F0, 0x0810, 0x0670, 0x0C30, 0x0E00, 0x0E00, 0x0E40, 0x0AB0, 0x06B0, 0x0CD0, 0x0C60, 0x0000, 0x06C0, 0x0000, 0x0400,
    0x0100, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0C60, 0x0000, 0x06C0, 0x0000, 0x0000
    };
    short element[8];
    short ppair[4];
    string nullArray = "      ";

dispBoB::dispBoB(PinName sda, PinName scl, PinName en): _pca(sda, scl), _en(en) {
    init();
}
void dispBoB::init(void){                           //initiate - call this whenever the system needs to be reset
    _en = 0;
    _pca.init(loc[0]);
    _pca.init(loc[2]);
    _pca.init(loc[4]);
    _pca.init(loc[6]);
}

void dispBoB::cls(void){                            //clear screen and screen buffers
    for(int j = 0; j < 8; j++){
        locate(j);
        element[j] = 0x0000;
        _pca.bus(0x0000);
    }
    locate(0);
}

void dispBoB::locate(char pos){
    _pca.setAddress(loc[pos]);
    _cursor = pos;
}

int dispBoB::_putc(int c){
    if(_cursor>6){
        _cursor++;
        return -1;                                  //skip if exceeds display size allow extra '.' in 6th >> to place in 5th
    }
    
    if(c=='.'){                                     //choose not to print a '.' outside the display bounds
        if(_cursor>6){
            _cursor++;
            return -1;
        }
        if((_cursor==0)&&((element[_cursor]&0x1000)==0x1000)) element[_cursor] = 0x0000;  
        if(_cursor!=0) _cursor--; 
        if(((element[_cursor]&0x1000)==0x1000)||((element[_cursor]&0x0100)==0x0100)){
            _cursor++;
            element[_cursor]=0x0000;  
        }
    } else {                                        
        if(_cursor>5){                              //for non '.' chars at end of line, flag up overflow and don't print 
            _cursor++;
            return -1;
        }  
        element[_cursor]=0x0000;                    //reset an element before pasting a char other than '.'
    }
   
    if(_cursor & 1){                                //look up char >> element conversion and paste to display
        element[_cursor] |= dispR[toupper(c)];
    } else {
        element[_cursor] |= dispL[toupper(c)];
    }
    
    int i = _cursor/2;
    ppair[i] = element[(2*i)] + element[(2*i)+1];   //combine left and right elements into a form readable by the PCA9635

    _pca.setAddress(loc[_cursor]);                  //set location to paste to   
    bus(ppair[i]);                                  //sned data tp PCA9635
    
    locate(_cursor+1);                              //allow cursor to be in element[6], decision of what to do
                                                    //is made at the start of the putc() algo. depending on char.
    return c;
}

int dispBoB::_getc(){
    return -1;
}

void dispBoB::scroll(string str, float speed){
    char buffer[12];                                //instantiate a 12 element buffer array
    str.insert(0, nullArray);                       //paste 6 zeros at either end of string 
    str.insert(str.length(), nullArray);
    
    for(int k = 0; k < str.length(); k++){          
        str.copy(buffer, 12, k);                    //mask a 12 element buffer starting at k
        locate(0);                                  //locate to position 0
        printf("%s", buffer);                       //print buffer to display
        if((element[0]&0x1000)==0x1000){            //if position zero has two characters i.e. char + '.'
            if(element[0]!=0x1000)k++;              //then treat as one
            else;
        }                                  
        wait(speed);                                //hold frame for duration of speed x milliseconds
    }
}

//supply PCA9635 functionality to dispBoB class
void dispBoB::bus(short leds){
    _pca.bus(leds);
}









