//NXP PCA9635 library
//mbed Team     -   28th June 2011
//Daniel Worrall

#ifndef MBED_DISPBOB_H
#define MBED_DISPBOB_H

#include "mbed.h"
#include "string"
#include "PCA9635.h"
#include "ctype.h"

/** dispBoB class, defined on the I2C master bus
* 
* Example:
* @code
* #include "mbed.h"
* #include "dispBoB.h"
*
* dispBoB db(p28, p27, p26);
* string str = "This is London calling";
*
* int main() {
*     db.cls();
*     while(1){
*         db.scroll(str, 0.25);
*     }
* }
* @endcode
*/
class dispBoB : public Stream {
public:
    //constructor
    /** Create a dispBoB object defined on the I2C master bus
    *
    * @param sda I2C data line
    * @param scl I2C clock line
    * @param en enable line
    */
    dispBoB(PinName sda, PinName scl, PinName en);
    
    //Output control
    
    /** Initialise device
    *
    */
    void init(void);
    /** Clear screen
    *
    */
    virtual void cls(void);
    /** Set cursor position
    *
    * @param pos display location left to right (0-5)
    */
    virtual void locate(char pos);    
    /** Write a scrolling string (right to left) to display 
    *
    * @param str String to be displayed (no punctuation)
    * @param speed duration of each frame (seconds)
    */
    void scroll(string str, float speed);
    /** Same functionality as the bus() function on the PCA9635
    *
    * @param leds Set output according to parameter value - e.g. 0x0003 >> p0 & p1 high, rest low 
    */
    void bus(short leds);
    
#if DOXYGEN_ONLY
    /** Write a character to the display
     *
     * @param c The character to write to the display
     */
    int putc(int c);
    /** Write a formated string to the LCD
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string. N.B. it will
     *               only display the first 6 characters.
     */
    int printf(const char* format, ...);
#endif
    
protected:

    //Stream implementation functions
    virtual int _putc(int c);
    virtual int _getc();

    PCA9635 _pca;
    DigitalOut _en;
    char _cursor; 
};

#endif

