//NXP PCA9635 library
//mbed Team     -   1st June 2011
//Ioannis Kedros
//updated by Daniel Worrall - 28th June 2011

#ifndef MBED_PCA9635_H
#define MBED_PCA9635_H

#include "mbed.h"

/** PCA9635 class defined on an I2C master bus
*
* Example:
* @code
* //Turn each output on and then off in order p0 >> p15
* //then ramp brightenss up and down at different speeds. 
* #include "mbed.h"
* #include "PCA9635.h"
* 
* DigitalOut enable(p26);
* PCA9635 my_driver(p28, p27);
* 
* int main()
* {
*     enable = 0;
*     my_driver.init(0x02);
*     //N.B. you MUST declare init(int address), before calling any PCA9635 functions
*     //turns each pin on and then off
*
*     short op = 1;
*     for(char j = 0; j < 16; j++){ 
*         my_driver.bus(op);
*         wait(0.7);
*         op = (op << 1);
*     }
* 
*    //ramp brightness up three times faster than down, repeatedly
*
*     while(1)
*     {
*         for(char valueUp=0; valueUp<0xFF; (valueUp = valueUp + 3))
*         {
*             my_driver.brightness(ALL, valueUp);
*         }
*         
*         for(char valueD=0; valueD<0xFF; valueD++)
*         {
*             my_driver.brightness(ALL, (0xFF - valueD));
*             wait(0.007);
*         }
*     }
* }
* @endcode
*/

class PCA9635 {
        
    public:
    /** Create a PCA9635 object, connected to the specified I2C pins 
    *
    * @param sda Defines serial data line
    * @param scl Defines serial clock line
    */
        PCA9635(PinName sda, PinName scl);
        
        char cmd[2];
        
        //Output control
       
        /** Set a particular output on PCA9635 high
        *
        * @param led LED pin coordinates
        */
        void on(char led);
        /** Reset a particular output on PCA9635 low
        *
        * @param led LED pin coordinates
        */
        void off(char led);
        /**Set all pins passed as argument high or low for current address
        *
        * @param leds Set output according to parameter value - e.g. 0x0003 >> p0 & p1 high, rest low
        */
        void bus(short leds);
        /**Set all pins passed as argument high or low for specified address
        *
        * @param led Pin co-ordinates
        * @param value Brightness value
        */
        void brightness(char led, char value);
        /** Set write address
        *
        * &param address write address
        */
        void setAddress(int address);
        /** Reset chip 
        *
        */
        void reset(void);
        /** Initialise chip - MUST call this before calling any other functions
        *
        * @param address hardware address
        */
        void init(int address);
           
    private:
        I2C m_i2c;
        int m_addr;
        
        #define ALL 0xFF
};

#endif