#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "dispBoB.h"
#include "stdio.h"

EthernetNetIf eth; 
HTTPClient http;
dispBoB db(p28, p27, p26);
  
int main() {

    EthernetErr ethErr = eth.setup();           //Setup ethernet connection
    if(ethErr) return -1;
  
    db.init();                                  //initialise screen
    db.cls();
    
    HTTPText txt;                               //instantiate HTTPStream object
    while(1){
        HTTPResult r = http.get("http://mbed.net16.net/v1/messageEcho.php", &txt);   //load page into buffer
        if(r==HTTP_OK){
            string str = txt.gets();            //load web page intop string

            char buf[100];                      //instantiate buffer for message
            int i = 0;                          //instantiate integer for iterator
            do{
                buf[i] = str[i];                //copy characters into buffer until end of buffer
                i++;                            //or newline tag
            } while ((i<100)&&(str[i]!='\n'));
        
        db.scroll(buf, 0.2);                    //scroll message
        }
        wait(2);                                //wait 2 seconds before looping, so we don't pester the servers too much
    }
}








