#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "SDHCFileSystem.h"
#include "TLV320.h"

EthernetNetIf eth;                              //Ethernet object
HTTPClient http;                                //HTTP object
TLV320 audio(p9, p10, 52, p5, p6, p7, p8, p29); //TLV320 object
SDFileSystem sd(p11, p12, p13, p14, "sd");      //SD Card object
InterruptIn volumeSet(p17);                     //Pin to set volume
AnalogIn aIn(p19);                              //Volume control
FILE *infp;                                     //File pointer object
/* Useful buffers and pointers*/
int loadBufferA[512];    
volatile int readPointer = 0;
volatile int theta = 0;
/* Function to control volume */
void setVolume(void){
    audio.outputVolume(aIn, aIn);                 //this way we can forget about ADC fluctuations
}
/* Function to send data to TLV320 */
void play(void){ 
        audio.write(loadBufferA, readPointer, 8); 
        /* Some pointers */ 
        readPointer += 8;
        readPointer &= 0x1ff;
        theta -= 8;
}
/* Function to load buffer from SD Card */
void fillBuffer(FILE *file){
    fseek(file, 44, SEEK_SET);                     //skip the header file, to where the data starts
    while(!feof(file)){
        static volatile int writePointer = 0;
        if(theta < 512){
            loadBufferA[writePointer] = ((char)(fgetc(file))|((char)fgetc(file)<<8)|((char)fgetc(file)<<16)|((char)fgetc(file)<<24));
            /* More pointer fun */
            ++theta;
            ++writePointer;
            writePointer &= 0x1ff;
        }
    }
}
int main() {
    /* Set up audio */
    for(int j = 0; j < 512; ++j){
        loadBufferA[j] = 0;
    }
    volumeSet.rise(&setVolume);
    audio.power(0x07);
    audio.attach(&play);
    /* Setup ethernet connection */
    EthernetErr ethErr = eth.setup();           
    if(ethErr) return -1;
    /* Instantiate HTTPStream object */
    HTTPText txt;                               
    while(1){
        char buf[10];
        HTTPResult r = http.get("http://www.srcf.ucam.org/~dew35/mbed/v1/dispBoBApp.php", &txt);   //load page into buffer
        if(r==HTTP_OK){
            string str = txt.gets();                //load web page into string                            
            str.copy(buf,9,0);                      //load buffer with chunk of web page
            for(int k = 0; k < 10; ++k){            //transform data such that the number corresponds to the correctly labelled file
                if(buf[k] == 0x2E) buf[k] = 10;
                else buf[k] -= 0x30;
            }   
        }
        /* Play intro */
        infp = fopen("/sd/11.wav", "r");
        audio.start(TRANSMIT);
        fillBuffer(infp);
        audio.stop(); 
        fclose(infp);  
        /* Play a file for each number in FTSE100 index */
        for(int j = 0; j < 7; ++j){
            char strBuf[20];
            sprintf(strBuf, "/sd/%d.wav", buf[j]);  //create filename based on index
            infp = fopen(strBuf, "r");              //open said file
            audio.start(TRANSMIT);                  //play said file
            fillBuffer(infp);
            audio.stop(); 
            fclose(infp); 

        }
    }
}

