#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "dispBoB.h"
#include "stdio.h"

EthernetNetIf eth; 
HTTPClient http;
dispBoB db(p28, p27, p26);
  
int main() {

    EthernetErr ethErr = eth.setup();           //Setup ethernet connection
    if(ethErr) return -1;
  
    db.init();                                  //initialise screen
    db.cls();
    
    HTTPText txt;                               //instantiate HTTPStream object
    while(1){
        HTTPResult r = http.get("http://mbed.net16.net/v1/dispBoBApp.php", &txt);   //load page into buffer
        if(r==HTTP_OK){
            string str = txt.gets();            //load web page into string

            char buf[10];                       //instantiate buffer and string to store FTSE100
            string value;                                  
            str.copy(buf,9,0);                  //load buffer with chunk of web page

            sscanf(buf, "%s", value);           //scan until decimal point
            
            db.scroll("FTSE100", 0.2);          //print info to dispBoB
            db.locate(0);
            db.printf("%s", value);                    
        }
        wait(2);                                //wait 2 seconds before looping, so we don't pester the servers too much
    }
}







