#include "mbed.h"
#include "dispBoB.h"

dispBoB db(p28, p27, p26);          //instantiate a dispBoB object
InterruptIn trigger(p12);           //set up the trigger as an external interrupt

int counter = 0;                    //initialise counter object to zero

void count(){                       //function to call upon interrupt
    counter++;                      //increment counter object
    db.locate(0);
    db.printf("%06d", counter);     //print counter info to dispBoB 
}

int main() {
    trigger.mode(PullUp);           //activate internal pull up (hardware specific)
    db.init();
    db.cls();                       //clear screen
    trigger.rise(&count);           //attach count() to interrupt on rising edge of trigger
    db.printf("%06d", counter);     //display an inital count "000000"
}
