/*  Pneumoscope Version 1.0
    Florian CHAYS
 */

// Defines for Registers
#define CONTROL0       0x00

// timing registers
#define LED2STC        0x01
#define LED2ENDC       0x02
#define LED2LEDSTC     0x03
#define LED2LEDENDC    0x04
#define ALED2STC       0x05
#define ALED2ENDC      0x06
#define LED1STC        0x07
#define LED1ENDC       0x08
#define LED1LEDSTC     0x09
#define LED1LEDENDC    0x0A
#define ALED1STC       0x0B
#define ALED1ENDC      0x0C
#define LED2CONVST     0x0D
#define LED2CONVEND    0x0E
#define ALED2CONVST    0x0F
#define ALED2CONVEND   0x10
#define LED1CONVST     0x11
#define LED1CONVEND    0x12
#define ALED1CONVST    0x13
#define ALED1CONVEND   0x14
#define ADCRSTSTCT0    0x15
#define ADCRSTENDCT0   0x16
#define ADCRSTSTCT1    0x17
#define ADCRSTENDCT1   0x18
#define ADCRSTSTCT2    0x19
#define ADCRSTENDCT2   0x1A
#define ADCRSTSTCT3    0x1B
#define ADCRSTENDCT3   0x1C
#define PRPCOUNT       0x1D

#define CONTROL1       0x1E
#define SPARE1         0x1F
#define TIAGAIN        0x20
#define TIA_AMB_GAIN   0x21
#define LEDCNTRL       0x22
#define CONTROL2       0x23
#define SPARE2         0x24
#define SPARE3         0x25
#define SPARE4         0x26
#define RESERVED1      0x27
#define RESERVED2      0x28
#define ALARM          0x29
#define LED2VAL        0x2A
#define ALED2VAL       0x2B
#define LED1VAL        0x2C
#define ALED1VAL       0x2D
#define LED2_ALED2VAL  0x2E
#define LED1_ALED1VAL  0x2F
#define DIAG           0x30

// ==== Globals ====
SPI spi(P1_3,P1_4,P1_6); // mosi, miso, sclk
DigitalOut cs(P1_5);
DigitalIn AFE_DIAG_END(P0_11);
DigitalIn button(P0_12);
DigitalOut myled(P0_13);
DigitalOut SUP_EN(P0_25);
DigitalIn ADC_READY(P1_1);
DigitalOut AFE_PDN(P1_2);
DigitalOut AFE_nRST(P1_7);
DigitalIn AFE_LED_ALM(P1_8);
DigitalIn AFE_PD_ALM(P1_9);

unsigned long   AFE_Default[49] = {
//Reg0: CONTROL0: CONTROL REGISTER 0
    0x00000,
//Reg1:REDSTARTCOUNT: SAMPLE RED START COUNT
    6000,
//Reg2:REDENDCOUNT: SAMPLE RED END COUNT
    7999,
//Reg3:REDLEDSTARTCOUNT: RED LED START COUNT
    6000,
//Reg4:REDLEDENDCOUNT: RED LED END COUNT
    7998,
//Reg5:AMBREDSTARTCOUNT: SAMPLE AMBIENT RED START COUNT
    0000,
//Reg6:AMBREDENDCOUNT: SAMPLE AMBIENT RED END COUNT
    1998,
//Reg7:IRSTARTCOUNT: SAMPLE IR START COUNT
    2000,
//Reg8:IRENDCOUNT: SAMPLE IR END COUNT
    3999,
//Reg9:IRLEDSTARTCOUNT: IR LED START COUNT
    2000,
//Reg10:IRLEDENDCOUNT: IR LED END COUNT
    3999,
//Reg11:AMBIRSTARTCOUNT: SAMPLE AMBIENT IR START COUNT
    4000,
//Reg12:AMBIRENDCOUNT: SAMPLE AMBIENT IR END COUNT
    5998,
//Reg13:REDCONVSTART: REDCONVST
    2,
//Reg14:REDCONVEND: RED CONVERT END COUNT
    1999,
//Reg15:AMBREDCONVSTART: RED AMBIENT CONVERT START COUNT
    2002,
//Reg16:AMBREDCONVEND: RED AMBIENT CONVERT END COUNT
    3999,
//Reg17:IRCONVSTART: IR CONVERT START COUNT
    4002,
//Reg18:IRCONVEND: IR CONVERT END COUNT
    5999,
//Reg19:AMBIRCONVSTART: IR AMBIENT CONVERT START COUNT
    6002,
//Reg20:AMBIRCONVEND: IR AMBIENT CONVERT END COUNT
    7999,
//Reg21:ADCRESETSTCOUNT0: ADC RESET 0 START COUNT
    0,
//Reg22:ADCRESETENDCOUNT0: ADC RESET 0 END COUNT
    2,
//Reg23:ADCRESETSTCOUNT1: ADC RESET 1 START COUNT
    2000,
//Reg24:ADCRESETENDCOUNT1: ADC RESET 1 END COUNT
    2002,
//Reg25:ADCRESETENDCOUNT2: ADC RESET 2 START COUNT
    4000,
//Reg26:ADCRESETENDCOUNT2: ADC RESET 2 END COUNT
    4002,
//Reg27:ADCRESETENDCOUNT3: ADC RESET 3 START COUNT
    6000,
//Reg28:ADCRESETENDCOUNT3: ADC RESET 3 END COUNT
    6002,
//Reg29:PRPCOUNT: PULSE REPETITION PERIOD COUNT
    7999,
//Reg30:CONTROL1: CONTROL REGISTER 1
    0x00107,  //timer enabled, averages=3, RED and IR LED pulse ON PD_ALM AND LED_ALM pins
//Reg31:?: ??
    0x00000,
//Reg32:TIAGAIN: TRANS IMPEDANCE AMPLIFIER GAIN SETTING REGISTER
    0x00000,
//Reg33:TIA_AMB_GAIN: TRANS IMPEDANCE AAMPLIFIER AND AMBIENT CANELLATION STAGE GAIN
    0x00000,
//Reg34:LEDCNTRL: LED CONTROL REGISTER
    0x11414,
//Reg35:CONTROL2: CONTROL REGISTER 2
    0x00000, //bit 9
//Reg36:?: ??
    0x00000,
//Reg37:?: ??
    0x00000,
//Reg38:?: ??
    0x00000,
//Reg39:?: ??
    0x00000,
//Reg40:: ??
    0x00000,
//Reg41:ALARM: ??
    0x00000,
//Reg42:REDVALUE: RED DIGITAL SAMPLE VALUE
    0x00000,
//Reg43:AMBREDVALUE: Ambient RED Digital Sample Value
    0x00000,
//Reg44:IRVALUE: IR Digital Sample Value
    0x00000,
//Reg45:AMBIRVALUE: Ambient IR Digital Sample Value
    0x00000,
//Reg46:RED-AMBREDVALUE: RED-AMBIENT RED DIGITAL SAMPLE VALUE
    0x00000,
//Reg47:IR-AMBIRVALUE: IR-AMBIENT IR DIGITAL SAMPLE VALUE
    0x00000,
//Reg48:DIGNOSTICS: DIAGNOSTICS FLAGS REGISTER
    0x00000
};

// ==== Prototypes ====
void SPI_Write(char address, uint32_t data);
uint32_t SPI_Read(char raddress);
void SPI_Write_Bit(char address, uint8_t bit, bool bit_high);

void AFE_reset();
void AFE_begin();
void AFE_set_LED_current(uint8_t led1_current, uint8_t led2_current);
void AFE_measurement();
void AFE_register_state();
void AFE_control_register();
void AFE_diag_flag();
void AFE_Results();

bool error_check(int index, uint32_t data_in, uint32_t data_out);
void blinky(int delay);